/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AnonymousUserContextRedirectionFilter
implements Filter {
    private static final String CONTEXT_NAME_PARAMETER = "context-name";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.frameworks.servlet.AnonymousUserContextRedirectionFilter");
    private String contextName;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String user = httpRequest.getRemoteUser();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Current user '" + user + "'."));
        }
        if (user != null) {
            filterChain.doFilter(request, response);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Redirect user to context '" + this.contextName + "'."));
            }
            String pathInfo = httpRequest.getPathInfo();
            String query = httpRequest.getQueryString();
            ((HttpServletResponse)response).sendRedirect(AnonymousUserContextRedirectionFilter.encodeURL(this.contextName + pathInfo) + (String)(query != null ? "?" + query : ""));
        }
    }

    private static String encodeURL(String url) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        String[] paths = url.split("/");
        for (int i = 0; i < paths.length; ++i) {
            if ("".equals(paths[i])) continue;
            String t = URLEncoder.encode(paths[i], "UTF-8");
            t = t.replace("+", "%20");
            sb.append('/').append(t);
        }
        return sb.toString();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.contextName = filterConfig.getInitParameter(CONTEXT_NAME_PARAMETER);
        if (this.contextName == null) {
            LOG.error((Object)"AnonymousUserContextRedirectionFilter is not deployed. Set Init-param 'context-name pointed to the target context name in the web.xml");
            throw new ServletException("Filter error. Init-param 'context-name' is null.");
        }
    }
}

