/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.impl.ApplicationProviders;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.provider.StringEntityProvider;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.GenericMethodResource;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;

public class ApplicationTest
extends BaseTest {
    private static boolean requestFilter = false;
    private static boolean responseFilter = false;
    private static boolean invFilter = false;
    private static final String message = "prOVIDers preFERence";

    public void testRegistry() {
        Application1 app = new Application1();
        this.applicationRegistry.addApplication((Application)app);
        ApplicationTest.assertEquals((int)4, (int)this.binder.getSize());
        ApplicationProviders appProviders = this.providersRegistry.getProviders(((Object)((Object)app)).getClass().getName());
        ApplicationTest.assertEquals((int)1, (int)appProviders.getRequestFilters(null).size());
        ApplicationTest.assertEquals((int)1, (int)appProviders.getResponseFilters(null).size());
        ApplicationTest.assertEquals((int)1, (int)appProviders.getMethodInvokerFilters(null).size());
        ApplicationTest.assertNotNull((Object)appProviders.getExceptionMapper(RuntimeException.class));
        ApplicationTest.assertNotNull((Object)appProviders.getExceptionMapper(IllegalStateException.class));
    }

    public void testAsResources() throws Exception {
        this.applicationRegistry.addApplication((Application)new Application1());
        ContainerResponse resp = this.launcher.service("GET", "/a", "", null, null, null);
        ApplicationTest.assertEquals((int)200, (int)resp.getStatus());
        String hash10 = (String)resp.getEntity();
        resp = this.launcher.service("GET", "/a", "", null, null, null);
        String hash11 = (String)resp.getEntity();
        ApplicationTest.assertFalse((boolean)hash10.equals(hash11));
        resp = this.launcher.service("GET", "/c", "", null, null, null);
        ApplicationTest.assertEquals((int)200, (int)resp.getStatus());
        String hash20 = (String)resp.getEntity();
        resp = this.launcher.service("GET", "/c", "", null, null, null);
        String hash21 = (String)resp.getEntity();
        ApplicationTest.assertTrue((boolean)hash20.equals(hash21));
        resp = this.launcher.service("GET", "/b", "", null, null, null);
        ApplicationTest.assertEquals((int)200, (int)resp.getStatus());
        ApplicationTest.assertEquals((Object)"test Runtime Exception", (Object)resp.getEntity());
        resp = this.launcher.service("GET", "/d", "", null, null, null);
        ApplicationTest.assertEquals((int)200, (int)resp.getStatus());
        ApplicationTest.assertEquals((Object)"test Illegal State Exception", (Object)resp.getEntity());
        ApplicationTest.assertTrue((boolean)requestFilter);
        ApplicationTest.assertTrue((boolean)responseFilter);
        ApplicationTest.assertTrue((boolean)invFilter);
    }

    public void testProvidersPreference() throws Exception {
        this.applicationRegistry.addApplication((Application)new Application2());
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("POST", "/abc", "", null, message.getBytes(), (ContainerResponseWriter)writer, null);
        ApplicationTest.assertEquals((int)200, (int)resp.getStatus());
        ApplicationTest.assertEquals((String)message.toLowerCase(), (String)new String(writer.getBody()));
    }

    public static class Application1
    extends Application {
        private final Set<Class<?>> perreq = new HashSet();
        private final Set<Object> singletons = new HashSet<Object>();

        public Application1() {
            this.perreq.add(Resource1.class);
            this.perreq.add(Resource2.class);
            this.perreq.add(ExceptionMapper1.class);
            this.perreq.add(MethodInvokerFilter1.class);
            this.perreq.add(RequestFilter1.class);
            this.singletons.add(new Resource3());
            this.singletons.add(new Resource4());
            this.singletons.add(new ExceptionMapper2());
            this.singletons.add(new ResponseFilter1());
        }

        public Set<Class<?>> getClasses() {
            return this.perreq;
        }

        public Set<Object> getSingletons() {
            return this.singletons;
        }
    }

    public static class Application2
    extends Application {
        private final Set<Class<?>> perreq = new HashSet();
        private final Set<Object> singletons = new HashSet<Object>();

        public Application2() {
            this.perreq.add(Resource5.class);
            this.singletons.add((Object)new StringEntityProvider1());
        }

        public Set<Class<?>> getClasses() {
            return this.perreq;
        }

        public Set<Object> getSingletons() {
            return this.singletons;
        }
    }

    @Provider
    public static class StringEntityProvider1
    extends StringEntityProvider {
        public String readFrom(Class<String> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream).toUpperCase();
        }

        public void writeTo(String t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
            super.writeTo(t.toLowerCase(), type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
    }

    @Path(value="abc")
    public static class Resource5 {
        @POST
        public String m0(String m) {
            TestCase.assertEquals((String)ApplicationTest.message.toUpperCase(), (String)m);
            return m;
        }
    }

    @Filter
    public static class ResponseFilter1
    implements ResponseFilter {
        public void doFilter(GenericContainerResponse response) {
            responseFilter = true;
        }
    }

    @Filter
    public static class RequestFilter1
    implements RequestFilter {
        public void doFilter(GenericContainerRequest request) {
            requestFilter = true;
        }
    }

    @Filter
    public static class MethodInvokerFilter1
    implements MethodInvokerFilter {
        public void accept(GenericMethodResource genericMethodResource) {
            invFilter = true;
        }
    }

    @Provider
    public static class ExceptionMapper2
    implements ExceptionMapper<IllegalStateException> {
        public Response toResponse(IllegalStateException exception) {
            return Response.status((int)200).entity((Object)exception.getMessage()).build();
        }
    }

    @Provider
    public static class ExceptionMapper1
    implements ExceptionMapper<RuntimeException> {
        public Response toResponse(RuntimeException exception) {
            return Response.status((int)200).entity((Object)exception.getMessage()).build();
        }
    }

    @Path(value="d")
    public static class Resource4 {
        @GET
        public void m0() {
            throw new IllegalStateException("test Illegal State Exception");
        }
    }

    @Path(value="c")
    public static class Resource3 {
        @GET
        public String m0() {
            return "" + this.hashCode();
        }
    }

    @Path(value="b")
    public static class Resource2 {
        @GET
        public void m0() {
            throw new RuntimeException("test Runtime Exception");
        }
    }

    @Path(value="a")
    public static class Resource1 {
        @GET
        public String m0() {
            return "" + this.hashCode();
        }
    }
}

