/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;

public class ExceptionsTest
extends BaseTest {
    private static String errorMessage = "test-error-message";
    private Resource1 resource;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.resource = new Resource1();
        this.registry(this.resource);
    }

    @Override
    public void tearDown() throws Exception {
        this.unregistry(this.resource);
        super.tearDown();
    }

    public void testErrorResponse() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/a/4", "", null, null, (ContainerResponseWriter)writer, null);
        ExceptionsTest.assertEquals((int)500, (int)response.getStatus());
        String entity = new String(writer.getBody());
        ExceptionsTest.assertEquals((String)errorMessage, (String)entity);
    }

    public void testUncheckedException() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/a/3", "", null, null, (ContainerResponseWriter)writer, null);
        ExceptionsTest.assertEquals((int)500, (int)response.getStatus());
        String entity = new String(writer.getBody());
        ExceptionsTest.assertEquals((String)errorMessage, (String)entity);
    }

    public void testWebApplicationExceptionWithCause() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/a/0", "", null, null, (ContainerResponseWriter)writer, null);
        ExceptionsTest.assertEquals((int)500, (int)response.getStatus());
        String entity = new String(writer.getBody());
        ExceptionsTest.assertEquals((String)new Exception(errorMessage).toString(), (String)entity);
    }

    public void testWebApplicationExceptionWithoutCause() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/a/2", "", null, null, (ContainerResponseWriter)writer, null);
        ExceptionsTest.assertEquals((int)500, (int)response.getStatus());
        ExceptionsTest.assertNull((Object)response.getEntity());
    }

    public void testWebApplicationExceptionWithResponse() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/a/1", "", null, null, (ContainerResponseWriter)writer, null);
        ExceptionsTest.assertEquals((int)500, (int)response.getStatus());
        String entity = new String(writer.getBody());
        ExceptionsTest.assertEquals((String)errorMessage, (String)entity);
    }

    public void testErrorOnRequestLifeCycleEnd() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        try {
            FailingComponentRequestLifecycle.FAIL.set(true);
            this.launcher.service("GET", "/a/5", "", null, null, (ContainerResponseWriter)writer, null);
        }
        finally {
            FailingComponentRequestLifecycle.FAIL.set(false);
        }
    }

    @Path(value="a")
    public static class Resource1 {
        @GET
        @Path(value="0")
        public void m0() throws WebApplicationException {
            Exception e = new Exception(errorMessage);
            throw new WebApplicationException((Throwable)e, 500);
        }

        @GET
        @Path(value="1")
        public void m1() throws WebApplicationException {
            Response response = Response.status((int)500).entity((Object)errorMessage).type("text/plain").build();
            throw new WebApplicationException((Throwable)new Exception(), response);
        }

        @GET
        @Path(value="2")
        public Response m2() throws WebApplicationException {
            throw new WebApplicationException(500);
        }

        @GET
        @Path(value="3")
        public void m3() throws Exception {
            throw new RuntimeException(errorMessage);
        }

        @GET
        @Path(value="4")
        public Response m4() throws Exception {
            return Response.status((int)500).entity((Object)errorMessage).type("text/plain").build();
        }

        @GET
        @Path(value="5")
        public Response m5() throws Exception {
            return Response.status((int)200).entity((Object)"My normal result").type("text/plain").build();
        }
    }

    public static class FailingComponentRequestLifecycle
    implements ComponentRequestLifecycle {
        public static AtomicBoolean FAIL = new AtomicBoolean();

        public void startRequest(ExoContainer container) {
        }

        public void endRequest(ExoContainer container) {
            if (FAIL.get()) {
                throw new RuntimeException(errorMessage);
            }
        }
    }
}

