/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

public class ResponseImplTest
extends BaseTest {
    public void testSetHeader() throws Exception {
        Response response = Response.ok().language(new Locale("en", "GB")).language(new Locale("en", "US")).type(new MediaType("text", "plain")).location(new URI("http://exoplatform.org/ws/rs/test")).cookie(new NewCookie[]{new NewCookie("name1", "value1")}).cookie(new NewCookie[]{new NewCookie("name2", "value2")}).tag(new EntityTag("123456789", true)).lastModified(new Date(1000L)).build();
        ArrayList<String> l = new ArrayList<String>();
        l.add("location:http://exoplatform.org/ws/rs/test");
        l.add("set-cookie:name1=value1;Version=1");
        l.add("set-cookie:name2=value2;Version=1");
        l.add("content-language:en-us");
        l.add("content-type:text/plain");
        l.add("etag:W/\"123456789\"");
        l.add("last-modified:Thu, 01 Jan 1970 00:00:01 GMT");
        for (Map.Entry e : response.getMetadata().entrySet()) {
            String name = (String)e.getKey();
            for (Object o : (List)e.getValue()) {
                String h = name + ":" + HeaderHelper.getHeaderAsString(o);
                ResponseImplTest.assertTrue((boolean)l.contains(h));
            }
        }
    }

    public void testVariant() {
        Response response = Response.ok().variant(new Variant(new MediaType("text", "xml"), new Locale("en", "GB"), "UTF-8")).build();
        ResponseImplTest.assertEquals((String)"text/xml", (String)HeaderHelper.getHeaderAsString((Object)response.getMetadata().getFirst((Object)"content-type")));
        ResponseImplTest.assertEquals((String)"UTF-8", (String)HeaderHelper.getHeaderAsString((Object)response.getMetadata().getFirst((Object)"content-encoding")));
        ResponseImplTest.assertEquals((String)"en-gb", (String)HeaderHelper.getHeaderAsString((Object)response.getMetadata().getFirst((Object)"content-language")));
    }

    public void testVariants() {
        ArrayList<Variant> vs = new ArrayList<Variant>(3);
        vs.add(new Variant(new MediaType("text", "xml"), null, null));
        vs.add(new Variant(null, null, "KOI8-R"));
        vs.add(new Variant(null, new Locale("ru", "RU"), null));
        Response response = Response.ok().variants(vs).build();
        ResponseImplTest.assertEquals((Object)"Accept,Accept-Language,Accept-Encoding", (Object)response.getMetadata().getFirst((Object)"vary"));
        vs.remove(1);
        response = Response.ok().variants(vs).build();
        ResponseImplTest.assertEquals((Object)"Accept,Accept-Language", (Object)response.getMetadata().getFirst((Object)"vary"));
        vs.remove(0);
        response = Response.ok().variants(vs).build();
        ResponseImplTest.assertEquals((Object)"Accept-Language", (Object)response.getMetadata().getFirst((Object)"vary"));
        vs.clear();
        response = Response.ok().variants(vs).build();
        ResponseImplTest.assertNull((Object)response.getMetadata().getFirst((Object)"vary"));
    }

    public void testRemoveHeaders() {
        Response response = Response.ok().header("foo", (Object)"bar").header("foo", (Object)"to be or not to be").header("foo", null).build();
        ResponseImplTest.assertNull((Object)response.getMetadata().get((Object)"foo"));
        response = Response.ok().header("foo2", (Object)"bar").header("foo1", (Object)"to be or not to be").header("foo2", null).build();
        ResponseImplTest.assertNull((Object)response.getMetadata().get((Object)"foo2"));
        ResponseImplTest.assertEquals((int)1, (int)((List)response.getMetadata().get((Object)"foo1")).size());
        ResponseImplTest.assertEquals((Object)"to be or not to be", (Object)response.getMetadata().getFirst((Object)"foo1"));
    }
}

