/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriInfo;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.Property;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;

public class ParametersInjectionTest
extends BaseTest {
    public void testParameterTypes() throws Exception {
        Resource1 r1 = new Resource1();
        this.registry(r1);
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/0/test", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/1/test", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/2/test", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/3/test", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/3333/4/2222", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/5555/5/4444", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/6/test", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/7/test?x=1&y=2&x=3&y=4&x=5", "", null, null, null).getStatus());
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"foo", (Object)"to be or not to be");
        h.putSingle((Object)"bar", (Object)"to be or not to be");
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/8/test", "", (Map)h, null, null).getStatus());
        h.clear();
        h.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("POST", "/a/test/9/test", "", (Map)h, "bar=to%20be%20or%20not%20to%20be&foo=to%20be%20or%20not%20to%20be".getBytes("UTF-8"), null).getStatus());
        h.clear();
        h.putSingle((Object)"Cookie", (Object)"$Version=1;foo=foo;$Domain=exo.com;$Path=/exo,$Version=1;bar=ar;$Domain=exo.com;$Path=/exo");
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/test/11/test", "", (Map)h, null, null).getStatus());
        ParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/111/12/222", "", null, null, null).getStatus());
        ParametersInjectionTest.assertEquals((Object)"111", (Object)this.launcher.service("GET", "/a/111/13", "", null, null, null).getEntity());
        ParametersInjectionTest.assertEquals((Object)"222", (Object)this.launcher.service("GET", "/a/111/13?query=222", "", null, null, null).getEntity());
        try {
            ParametersInjectionTest.assertEquals((Object)"hello", (Object)this.launcher.service("GET", "/a/111/14", "", null, null, null).getEntity());
            RequestHandlerImpl.setProperty((String)"prop1", (String)"to be or not to be");
            ParametersInjectionTest.assertEquals((Object)"to be or not to be", (Object)this.launcher.service("GET", "/a/111/14", "", null, null, null).getEntity());
        }
        finally {
            RequestHandlerImpl.setProperty((String)"prop1", null);
        }
        this.unregistry(r1);
    }

    @Path(value="/a/{x}")
    public static class Resource1 {
        @GET
        @Path(value="/0/{y}/")
        public void m0(@PathParam(value="x") String x, @PathParam(value="y") String y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((String)x, (String)y);
        }

        @GET
        @Path(value="/1/{y}/")
        public void m1(@PathParam(value="x") List<String> x, @PathParam(value="y") List<String> y) {
            TestCase.assertNotNull(x);
            TestCase.assertEquals((int)1, (int)x.size());
            TestCase.assertNotNull(y);
            TestCase.assertEquals((int)1, (int)y.size());
            TestCase.assertEquals(x, y);
        }

        @GET
        @Path(value="/2/{y}/")
        public void m2(@PathParam(value="x") Set<String> x, @PathParam(value="y") Set<String> y) {
            TestCase.assertNotNull(x);
            TestCase.assertEquals((int)1, (int)x.size());
            TestCase.assertNotNull(y);
            TestCase.assertEquals((int)1, (int)y.size());
            TestCase.assertEquals(x, y);
        }

        @GET
        @Path(value="/3/{y}/")
        public void m3(@PathParam(value="x") SortedSet<String> x, @PathParam(value="y") SortedSet<String> y) {
            TestCase.assertNotNull(x);
            TestCase.assertEquals((int)1, (int)x.size());
            TestCase.assertNotNull(y);
            TestCase.assertEquals((int)1, (int)y.size());
            TestCase.assertEquals(x, y);
        }

        @GET
        @Path(value="/4/{y}/")
        public void m4(@PathParam(value="x") Integer x, @PathParam(value="y") Integer y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((int)1111, (int)(x - y));
        }

        @GET
        @Path(value="/5/{y}/")
        public void m5(@PathParam(value="x") long x, @PathParam(value="y") long y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((long)1111L, (long)(x - y));
        }

        @GET
        @Path(value="/6/{y}/")
        public void m6(@PathParam(value="x") Test x, @PathParam(value="y") Test y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((String)x.toString(), (String)y.toString());
        }

        @GET
        @Path(value="/7/{y}/")
        public void m7(@QueryParam(value="x") List<String> x, @QueryParam(value="y") List<String> y) {
            TestCase.assertNotNull(x);
            TestCase.assertEquals((int)3, (int)x.size());
            TestCase.assertNotNull(y);
            TestCase.assertEquals((int)2, (int)y.size());
            TestCase.assertEquals((String)"1", (String)x.get(0));
            TestCase.assertEquals((String)"3", (String)x.get(1));
            TestCase.assertEquals((String)"5", (String)x.get(2));
            TestCase.assertEquals((String)"2", (String)y.get(0));
            TestCase.assertEquals((String)"4", (String)y.get(1));
        }

        @GET
        @Path(value="/8/{y}/")
        public void m8(@HeaderParam(value="foo") String x, @HeaderParam(value="bar") String y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((String)x, (String)y);
        }

        @POST
        @Path(value="/9/{y}/")
        public void m9(@FormParam(value="foo") String x, @FormParam(value="bar") String y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((String)x, (String)y);
        }

        @GET
        @Path(value="/10/{y}/")
        public void m10(@MatrixParam(value="foo") int x, @MatrixParam(value="bar") int y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((int)1111, (int)(x - y));
        }

        @GET
        @Path(value="/11/{y}/")
        public void m11(@CookieParam(value="foo") Cookie x, @CookieParam(value="bar") Cookie y) {
            TestCase.assertNotNull((Object)x);
            TestCase.assertNotNull((Object)y);
            TestCase.assertEquals((String)x.getDomain(), (String)y.getDomain());
            TestCase.assertEquals((String)x.getPath(), (String)y.getPath());
        }

        @GET
        @Path(value="/12/{y}/")
        public void m12(@Context UriInfo uriInfo) {
            TestCase.assertNotNull((Object)uriInfo);
            TestCase.assertEquals((int)2, (int)uriInfo.getPathParameters().size());
        }

        @GET
        @Path(value="/13")
        public String m13(@QueryParam(value="query") @DefaultValue(value="111") String param) {
            TestCase.assertNotNull((Object)param);
            return param;
        }

        @GET
        @Path(value="/14")
        public String m14(@Property(value="prop1") @DefaultValue(value="hello") String prop) {
            TestCase.assertNotNull((Object)prop);
            return prop;
        }
    }

    public static class Test {
        private final String s;

        public Test(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

