/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.Property;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.test.mock.MockHttpServletRequest;

public class RequestDispatcherTest
extends BaseTest {
    public void testResource1() throws Exception {
        Resource1 r1 = new Resource1();
        this.registry(r1);
        RequestDispatcherTest.assertEquals((Object)"m0", (Object)this.launcher.service("POST", "/a", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m1", (Object)this.launcher.service("POST", "/a/b", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m2.0", (Object)this.launcher.service("POST", "/a/b/c", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m2.1", (Object)this.launcher.service("POST", "/a/b/c/d", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m3.0", (Object)this.launcher.service("POST", "/a/b/c/d/e", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m3.1", (Object)this.launcher.service("POST", "/a/b/c/d/e/f", "", null, null, null).getEntity());
        this.unregistry(r1);
    }

    public void testResource2() throws Exception {
        Resource2 r2 = new Resource2();
        this.registry(r2);
        RequestDispatcherTest.assertEquals((Object)"m0", (Object)this.launcher.service("POST", "/", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m1", (Object)this.launcher.service("POST", "/a", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"#x y", (Object)this.launcher.service("POST", "/1/a/b%20/c/%23x%20y", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"%23x%20y", (Object)this.launcher.service("POST", "/2/a/b%20/c/%23x%20y", "", null, null, null).getEntity());
        this.unregistry(r2);
    }

    public void testResourceConstructorAndFields() throws Exception {
        this.registry(Resource3.class);
        RequestDispatcherTest.assertEquals((Object)"/a/b/c/d/m0", (Object)this.launcher.service("GET", "/a/b/c/d/m0", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"c", (Object)this.launcher.service("GET", "/a/b/c/d/m1", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"d", (Object)this.launcher.service("GET", "/a/b/c/d/m2", "", null, null, null).getEntity());
        this.unregistry(Resource3.class);
    }

    public void testResourceConstructorsContainer() throws Exception {
        this.container.registerComponentInstance((Object)TestContainerComponent.class.getName(), (Object)new TestContainerComponent());
        this.registry(Resource4.class);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("/aaa/bbb", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.launcher.service("GET", "/aaa/bbb", "", null, null, envctx);
        this.unregistry(Resource4.class);
    }

    public void testResourceConstructorFail() throws Exception {
        this.registry(ResourceFail.class);
        ContainerResponse resp = this.launcher.service("GET", "/_a/b/c/d/m0", "", null, null, null);
        String entity = (String)resp.getEntity();
        RequestDispatcherTest.assertTrue((boolean)entity.startsWith("Can't instantiate resource "));
        RequestDispatcherTest.assertEquals((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)resp.getStatus());
        this.unregistry(ResourceFail.class);
    }

    public void testResource5() throws Exception {
        this.registry(Resource5.class);
        this.launcher.service("GET", "/a/b/c/d?q1=q1&q2=q2", "", null, null, null);
        this.unregistry(Resource5.class);
    }

    public void testFieldSuperClass() throws Exception {
        this.registry(EndResource.class);
        this.launcher.service("GET", "/a", "", null, null, null);
        this.unregistry(EndResource.class);
    }

    public void testPropertyInjection() throws Exception {
        this.registry(Resource6.class);
        RequestHandlerImpl.setProperty((String)"prop1", (String)"hello");
        RequestHandlerImpl.setProperty((String)"prop2", (String)"test");
        this.launcher.service("GET", "/a", "", null, null, null);
        this.unregistry(Resource6.class);
    }

    public void testResource7() throws Exception {
        this.registry(Resource7.class);
        RequestDispatcherTest.assertEquals((Object)"m0.m1", (Object)this.launcher.service("GET", "/a/b/c/m0.m1.m2", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m0", (Object)this.launcher.service("GET", "/a/b/c/m0.m1", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m2", (Object)this.launcher.service("GET", "/a/b/e/m0.m1.m2", "", null, null, null).getEntity());
        RequestDispatcherTest.assertEquals((Object)"m2", (Object)this.launcher.service("GET", "/a/b/m0.m1.m2.m3", "", null, null, null).getEntity());
        this.unregistry(Resource7.class);
    }

    @Path(value="/a")
    public static class Resource1 {
        @POST
        public String m0() {
            return "m0";
        }

        @POST
        @Path(value="/b")
        public String m1() {
            return "m1";
        }

        @Path(value="b/c")
        public SubResource1 m2() {
            return new SubResource1();
        }
    }

    @Path(value="/")
    public static class Resource2 {
        @POST
        public String m0() {
            return "m0";
        }

        @POST
        @Path(value="a")
        public String m1() {
            return "m1";
        }

        @POST
        @Path(value="1/a/b /c/{d}")
        public String m2(@PathParam(value="d") String d) {
            return d;
        }

        @POST
        @Path(value="2/a/b /c/{d}")
        public String m3(@Encoded @PathParam(value="d") String d) {
            return d;
        }
    }

    @Path(value="/a/b/{c}/{d}")
    public static class Resource3 {
        @Context
        private UriInfo uriInfo;
        private String c;
        private String d;

        public Resource3(@PathParam(value="c") String c) {
            this.c = c;
        }

        public Resource3(@PathParam(value="c") String c, @PathParam(value="d") String d) {
            this.c = c;
            this.d = d;
        }

        @GET
        @Path(value="m0")
        public String m0() {
            return this.uriInfo.getRequestUri().toString();
        }

        @GET
        @Path(value="m1")
        public String m1() {
            return this.c;
        }

        @GET
        @Path(value="m2")
        public String m2() {
            return this.d;
        }
    }

    public static class TestContainerComponent {
    }

    @Path(value="{a}")
    public static class Resource4 {
        @Context
        private UriInfo uriInfo;
        @Context
        private HttpServletRequest request;
        private TestContainerComponent tc;

        public Resource4(@PathParam(value="a") String test) {
            TestCase.fail((String)"Must not be used.");
        }

        public Resource4(TestContainerComponent tc, @PathParam(value="a") String test) {
            this.tc = tc;
        }

        @GET
        @Path(value="{b}")
        public void m0() {
            TestCase.assertNotNull((Object)this.tc);
            TestCase.assertNotNull((Object)this.uriInfo);
            TestCase.assertNotNull((Object)this.request);
        }
    }

    @Path(value="/_a/b/{c}/{d}")
    public static class ResourceFail {
        public ResourceFail(Failure failure, @PathParam(value="c") String c, @PathParam(value="d") String d) {
        }

        @GET
        @Path(value="m0")
        public String m0() {
            return "m0";
        }
    }

    @Path(value="a/{b}/{c}")
    public static class Resource5 {
        @PathParam(value="b")
        private String b;
        private String c;
        @QueryParam(value="q1")
        private String q1;

        public Resource5(@PathParam(value="c") String c) {
            this.c = c;
        }

        @GET
        @Path(value="{d}")
        public void m1(@PathParam(value="d") String d, @QueryParam(value="q2") String q2) {
            TestCase.assertEquals((String)"b", (String)this.b);
            TestCase.assertEquals((String)"c", (String)this.c);
            TestCase.assertEquals((String)"d", (String)d);
            TestCase.assertEquals((String)"q1", (String)this.q1);
            TestCase.assertEquals((String)"q2", (String)q2);
        }
    }

    @Path(value="a")
    public static class EndResource
    extends ExtResource {
        @Context
        private HttpHeaders header;
        @Context
        private SecurityContext something;

        @GET
        public void m1() {
            TestCase.assertNotNull((Object)this.uriInfo);
            TestCase.assertNotNull((Object)this.request);
            TestCase.assertNotNull((Object)this.something);
            TestCase.assertNotNull((Object)((ExtResource)this).something);
            TestCase.assertTrue((boolean)(this.something instanceof SecurityContext));
            TestCase.assertTrue((boolean)(((ExtResource)this).something instanceof UriInfo));
            TestCase.assertNotNull((Object)this.sc);
            TestCase.assertNotNull((Object)this.header);
        }
    }

    @Path(value="a")
    public static class Resource6 {
        @Property(value="prop1")
        private String prop1;
        private final String prop2;

        public Resource6(@Property(value="prop2") String cProp) {
            this.prop2 = cProp;
        }

        @GET
        public void m1() {
            TestCase.assertEquals((String)"hello", (String)this.prop1);
            TestCase.assertEquals((String)"test", (String)this.prop2);
        }
    }

    @Path(value="/a")
    public static class Resource7 {
        @GET
        @Path(value="b/c/{d:.+}.{e}")
        public String m1(@PathParam(value="d") String d) {
            return d;
        }

        @GET
        @Path(value="b/e/{d:.+}.{e}")
        public String m2(@PathParam(value="e") String e) {
            return e;
        }

        @GET
        @Path(value="b/{d:.+}.{e}.{f}")
        public String m3(@PathParam(value="e") String e) {
            return e;
        }
    }

    public static abstract class ExtResource
    extends AbstractResource {
        @Context
        protected SecurityContext sc;
    }

    public static abstract class AbstractResource {
        @Context
        protected UriInfo uriInfo;
        @Context
        public Request request;
        @Context
        protected UriInfo something;
    }

    public static class Failure {
    }

    public static class SubResource2 {
        @POST
        public String m0() {
            return "m3.0";
        }

        @POST
        @Path(value="f")
        public String m1() {
            return "m3.1";
        }
    }

    public static class SubResource1 {
        @POST
        public String m0() {
            return "m2.0";
        }

        @POST
        @Path(value="d")
        public String m1() {
            return "m2.1";
        }

        @Path(value="d/e")
        public SubResource2 m2() {
            return new SubResource2();
        }
    }
}

