/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class JsonEntityProviderTest
extends BaseTest {
    private static final String DATA = "{\"name\":\"andrew\", \"password\":\"hello\"}";
    private MediaType mediaType;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        JsonEntityProviderTest.assertNotNull((Object)this.requestHandler);
        this.mediaType = new MediaType("application", "json");
    }

    public void testRead() throws Exception {
        MessageBodyReader reader = this.providers.getMessageBodyReader(Bean.class, null, null, this.mediaType);
        JsonEntityProviderTest.assertNotNull((Object)reader);
        JsonEntityProviderTest.assertTrue((boolean)reader.isReadable(Bean.class, Bean.class, null, this.mediaType));
        byte[] data = DATA.getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"Content-Length", (Object)("" + data.length));
        Bean bean = (Bean)reader.readFrom(Bean.class, Bean.class, null, this.mediaType, (MultivaluedMap)h, (InputStream)new ByteArrayInputStream(data));
        JsonEntityProviderTest.assertEquals((String)"andrew", (String)bean.getName());
        JsonEntityProviderTest.assertEquals((String)"hello", (String)bean.getPassword());
    }

    public void testWrite() throws Exception {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(Bean.class, null, null, this.mediaType);
        JsonEntityProviderTest.assertNotNull((Object)writer);
        JsonEntityProviderTest.assertTrue((boolean)writer.isWriteable(Bean.class, Bean.class, null, this.mediaType));
        Bean bean = new Bean();
        bean.setName("andrew");
        bean.setPassword("test");
        writer.writeTo((Object)bean, Bean.class, Bean.class, null, this.mediaType, null, (OutputStream)new ByteArrayOutputStream());
    }

    public static class Bean {
        private String name;
        private String password;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return "name=" + this.name + "; password=" + this.password;
        }
    }
}

