/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class AcceptResourceTest
extends BaseTest {
    public void testContentType() throws Exception {
        Resource1 r1 = new Resource1();
        this.registry(r1);
        AcceptResourceTest.assertEquals((String)"m0", (String)this.testContentType("text/html"));
        AcceptResourceTest.assertEquals((String)"m2", (String)this.testContentType("text/xml"));
        AcceptResourceTest.assertEquals((String)"m2", (String)this.testContentType("application/xml"));
        AcceptResourceTest.assertEquals((String)"m1", (String)this.testContentType("image/gif"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testContentType("image/jpeg"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testContentType("image/png"));
        AcceptResourceTest.assertEquals((String)"m4", (String)this.testContentType("application/x-www-form-urlencoded"));
        this.unregistry(r1);
    }

    public void testAcceptedMediaType() throws Exception {
        Resource2 r2 = new Resource2();
        this.registry(r2);
        AcceptResourceTest.assertEquals((String)"m0", (String)this.testAcceptedMediaType("text/plain;q=0.9,text/html;q=0.7,text/*;q=0.5"));
        AcceptResourceTest.assertEquals((String)"m0", (String)this.testAcceptedMediaType("text/plain;q=0.7,text/html;q=0.9,text/*;q=0.5"));
        AcceptResourceTest.assertEquals((String)"m0", (String)this.testAcceptedMediaType("text/plain;q=0.5,text/html;q=0.7,text/*;q=0.9"));
        AcceptResourceTest.assertEquals((String)"m1", (String)this.testAcceptedMediaType("text/xml;q=0.9,text/bell;q=0.5"));
        AcceptResourceTest.assertEquals((String)"m1", (String)this.testAcceptedMediaType("text/foo"));
        AcceptResourceTest.assertEquals((String)"m2", (String)this.testAcceptedMediaType("image/gif"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testAcceptedMediaType("image/jpeg;q=0.8,  image/png;q=0.9"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testAcceptedMediaType("image/foo;q=0.8,  image/png;q=0.9"));
        AcceptResourceTest.assertEquals((String)"m2", (String)this.testAcceptedMediaType("image/foo;q=0.9,  image/png;q=0.8"));
        AcceptResourceTest.assertEquals((String)"m2", (String)this.testAcceptedMediaType("image/foo;q=0.9,  image/gif;q=0.8"));
        AcceptResourceTest.assertEquals((String)"m4", (String)this.testAcceptedMediaType("application/x-www-form-urlencoded"));
        AcceptResourceTest.assertEquals((String)"m0", (String)this.testAcceptedMediaType("application/x-www-form-urlencoded;q=0.5,text/plain"));
        this.unregistry(r2);
    }

    public void testComplex() throws Exception {
        Resource3 r3 = new Resource3();
        this.registry(r3);
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testComplex("text/plain", "text/plain;q=0.9"));
        AcceptResourceTest.assertEquals((String)"m0", (String)this.testComplex("text/plain", "text/plain;q=0.3,text/xml;q=0.9"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testComplex("text/xml", "text/plain;q=0.9,text/html;q=0.3"));
        AcceptResourceTest.assertEquals((String)"m0", (String)this.testComplex("text/xml", "text/xml,text/*;q=0.3"));
        AcceptResourceTest.assertEquals((String)"m1", (String)this.testComplex("image/*", "image/*"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testComplex("image/*", "image/png"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testComplex("image/*", "image/png,image/gif;q=0.1"));
        AcceptResourceTest.assertEquals((String)"m1", (String)this.testComplex("image/*", "image/*,image/gif;q=0.1"));
        AcceptResourceTest.assertEquals((String)"m3", (String)this.testComplex("foo/bar", "foo/bar"));
        this.unregistry(r3);
    }

    private String testContentType(String contentType) throws Exception {
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)contentType);
        return (String)this.launcher.service("POST", "/a", "", (Map)h, null, null).getEntity();
    }

    private String testAcceptedMediaType(String acceptMediaType) throws Exception {
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)acceptMediaType);
        return (String)this.launcher.service("GET", "/a", "", (Map)h, null, null).getEntity();
    }

    private String testComplex(String contentType, String acceptMediaType) throws Exception {
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)contentType);
        h.putSingle((Object)"accept", (Object)acceptMediaType);
        return (String)this.launcher.service("POST", "/a", "", (Map)h, null, null).getEntity();
    }

    @Path(value="/a")
    public static class Resource1 {
        @POST
        @Consumes(value={"text/*"})
        public String m0() {
            return "m0";
        }

        @POST
        @Consumes(value={"image/*"})
        public String m1() {
            return "m1";
        }

        @POST
        @Consumes(value={"text/xml", "application/xml"})
        public String m2() {
            return "m2";
        }

        @POST
        @Consumes(value={"image/jpeg", "image/png"})
        public String m3() {
            return "m3";
        }

        @POST
        public String m4() {
            return "m4";
        }
    }

    @Path(value="/a")
    public static class Resource2 {
        @GET
        @Produces(value={"text/plain", "text/html"})
        public String m0() {
            return "m0";
        }

        @GET
        @Produces(value={"text/xml", "text/*"})
        public String m1() {
            return "m1";
        }

        @GET
        @Produces(value={"image/*"})
        public String m2() {
            return "m2";
        }

        @GET
        @Produces(value={"image/jpeg", "image/png"})
        public String m3() {
            return "m3";
        }

        @GET
        public String m4() {
            return "m4";
        }
    }

    @Path(value="/a")
    public static class Resource3 {
        @POST
        @Consumes(value={"text/plain", "text/xml"})
        @Produces(value={"text/xml"})
        public String m0() {
            return "m0";
        }

        @POST
        @Consumes(value={"image/*", "image/png"})
        @Produces(value={"image/gif"})
        public String m1() {
            return "m1";
        }

        @POST
        @Consumes(value={"application/xml", "text/xml"})
        @Produces(value={"text/html"})
        public String m2() {
            return "m2";
        }

        @POST
        public String m3() {
            return "m3";
        }
    }
}

