/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import junit.framework.TestCase;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ApplicationRegistry;
import org.exoplatform.services.rest.impl.DependencySupplier;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.ProvidersRegistry;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.tools.ResourceLauncher;

public abstract class BaseTest
extends TestCase {
    protected StandaloneContainer container;
    protected ProviderBinder providers;
    protected ResourceBinder binder;
    protected RequestHandlerImpl requestHandler;
    protected ResourceLauncher launcher;
    protected ApplicationRegistry applicationRegistry;
    protected ProvidersRegistry providersRegistry;

    public void setUp() throws Exception {
        String conf = ((Object)((Object)this)).getClass().getResource("/conf/standalone/test-configuration.xml").toString();
        StandaloneContainer.setConfigurationURL((String)conf);
        this.container = StandaloneContainer.getInstance();
        this.applicationRegistry = (ApplicationRegistry)this.container.getComponentInstanceOfType(ApplicationRegistry.class);
        this.binder = (ResourceBinder)this.container.getComponentInstanceOfType(ResourceBinder.class);
        this.requestHandler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        this.providersRegistry = (ProvidersRegistry)this.container.getComponentInstanceOfType(ProvidersRegistry.class);
        DependencySupplier dependencySupplier = (DependencySupplier)this.container.getComponentInstanceOfType(DependencySupplier.class);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        this.providers = ProviderBinder.getInstance();
        this.binder.clear();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providers, dependencySupplier));
        this.launcher = new ResourceLauncher((RequestHandler)this.requestHandler);
    }

    public void tearDown() throws Exception {
    }

    public void registry(Object resource) throws Exception {
        this.binder.addResource(resource, null);
    }

    public void registry(Class<?> resourceClass) throws Exception {
        this.binder.addResource(resourceClass, null);
    }

    public void unregistry(Object resource) {
        this.binder.removeResource(resource.getClass());
    }

    public void unregistry(Class<?> resourceClass) {
        this.binder.removeResource(resourceClass);
    }
}

