/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.test.mock.MockHttpServletRequest;

public class RequestFilterTest
extends BaseTest {
    public void testWithoutFilter1() throws Exception {
        this.registry(Resource1.class);
        ContainerResponse resp = this.launcher.service("GET", "/a", "", null, null, null);
        RequestFilterTest.assertEquals((int)405, (int)resp.getStatus());
        RequestFilterTest.assertEquals((int)1, (int)((List)resp.getHttpHeaders().get((Object)"allow")).size());
        RequestFilterTest.assertTrue((boolean)((List)resp.getHttpHeaders().get((Object)"allow")).get(0).toString().contains("POST"));
        this.unregistry(Resource1.class);
    }

    public void testWithFilter2() throws Exception {
        this.registry(Resource1.class);
        this.providers.addRequestFilter(RequestFilter1.class);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("/a", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("GET", "/a", "", null, null, envctx);
        RequestFilterTest.assertEquals((int)204, (int)resp.getStatus());
        this.unregistry(Resource1.class);
    }

    public void testFilter2() throws Exception {
        this.registry(Resource1.class);
        ContainerResponse resp = this.launcher.service("GET", "/a/b/c/d/e", "", null, null, null);
        RequestFilterTest.assertEquals((int)405, (int)resp.getStatus());
        RequestFilterTest.assertEquals((int)1, (int)((List)resp.getHttpHeaders().get((Object)"allow")).size());
        RequestFilterTest.assertTrue((boolean)((List)resp.getHttpHeaders().get((Object)"allow")).get(0).toString().contains("DELETE"));
        this.providers.addRequestFilter((RequestFilter)new RequestFilter2());
        resp = this.launcher.service("GET", "/a/b/c/d/e", "", null, null, null);
        RequestFilterTest.assertEquals((int)204, (int)resp.getStatus());
        this.unregistry(Resource1.class);
    }

    @Path(value="a")
    public static class Resource1 {
        @POST
        public void m0() {
        }

        @DELETE
        @Path(value="b/c/d/e")
        public void m1() {
        }

        @PUT
        @Path(value="c/d/e")
        public void m2() {
        }
    }

    @Filter
    public static class RequestFilter1
    implements RequestFilter {
        @Context
        private UriInfo uriInfo;
        @Context
        private HttpHeaders httpHeaders;
        private Providers providers;
        private HttpServletRequest httpRequest;
        private ResourceBinder binder;

        public RequestFilter1(@Context Providers providers, @Context HttpServletRequest httpRequest, ResourceBinder binder) {
            this.providers = providers;
            this.httpRequest = httpRequest;
            this.binder = binder;
        }

        public void doFilter(GenericContainerRequest request) {
            if (this.uriInfo != null && this.httpHeaders != null && this.providers != null && this.httpRequest != null && this.binder != null) {
                request.setMethod("POST");
            }
        }
    }

    @Path(value="a/b/c/{x:.*}")
    @Filter
    public static class RequestFilter2
    implements RequestFilter {
        public void doFilter(GenericContainerRequest request) {
            request.setMethod("DELETE");
        }
    }
}

