/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.InitialProperties;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

public class ContextParametersInjectionTest
extends BaseTest {
    public void testMethodContextInjection() throws Exception {
        Resource1 r1 = new Resource1();
        this.registry(r1);
        this.injectionTest();
        this.unregistry(r1);
    }

    public void testFieldInjection() throws Exception {
        this.registry(Resource2.class);
        this.injectionTest();
        this.unregistry(Resource2.class);
    }

    public void testConstructorInjection() throws Exception {
        this.registry(Resource3.class);
        this.injectionTest();
        this.unregistry(Resource3.class);
    }

    private void injectionTest() throws Exception {
        ContextParametersInjectionTest.assertEquals((Object)"http://localhost/test/a/b/c", (Object)this.launcher.service("GET", "http://localhost/test/a/b/c", "http://localhost/test", null, null, null).getEntity());
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.add((Object)"Accept", (Object)"text/xml");
        h.add((Object)"Accept", (Object)"text/plain;q=0.7");
        ContextParametersInjectionTest.assertEquals((Object)"text/xml,text/plain;q=0.7", (Object)this.launcher.service("GET", "http://localhost/test/a/b/d", "http://localhost/test", (Map)h, null, null).getEntity());
        ContextParametersInjectionTest.assertEquals((Object)"GET", (Object)this.launcher.service("GET", "http://localhost/test/a/b/e", "http://localhost/test", null, null, null).getEntity());
        ContextParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "http://localhost/test/a/b/f", "http://localhost/test", null, null, null).getStatus());
        ContextParametersInjectionTest.assertEquals((int)204, (int)this.launcher.service("GET", "http://localhost/test/a/b/g", "http://localhost/test", null, null, null).getStatus());
    }

    @Path(value="/a/b")
    public static class Resource1 {
        @GET
        @Path(value="c")
        public String m0(@Context UriInfo uriInfo) {
            return uriInfo.getRequestUri().toString();
        }

        @GET
        @Path(value="d")
        public String m1(@Context HttpHeaders headers) {
            List l = headers.getRequestHeader("Accept");
            return HeaderHelper.convertToString((Collection)l);
        }

        @GET
        @Path(value="e")
        public String m2(@Context Request request) {
            return request.getMethod();
        }

        @GET
        @Path(value="f")
        public void m3(@Context Providers providers) {
            TestCase.assertNotNull((Object)providers);
        }

        @GET
        @Path(value="g")
        public void m4(@Context InitialProperties properties) {
            TestCase.assertNotNull((Object)properties);
        }
    }

    @Path(value="/a/b")
    public static class Resource2 {
        @Context
        private UriInfo uriInfo;
        @Context
        private HttpHeaders headers;
        @Context
        private Request request;
        @Context
        private Providers providers;
        @Context
        private InitialProperties properties;

        @GET
        @Path(value="c")
        public String m0() {
            return this.uriInfo.getRequestUri().toString();
        }

        @GET
        @Path(value="d")
        public String m1() {
            List l = this.headers.getRequestHeader("Accept");
            return HeaderHelper.convertToString((Collection)l);
        }

        @GET
        @Path(value="e")
        public String m2() {
            return this.request.getMethod();
        }

        @GET
        @Path(value="f")
        public void m3() {
            TestCase.assertNotNull((Object)this.providers);
        }

        @GET
        @Path(value="g")
        public void m4() {
            TestCase.assertNotNull((Object)this.properties);
        }
    }

    @Path(value="/a/b")
    public static class Resource3 {
        private UriInfo uriInfo;
        private HttpHeaders headers;
        private Request request;
        private Providers providers;
        private InitialProperties properties;

        public Resource3(@Context UriInfo uriInfo, @Context HttpHeaders headers, @Context Request request, @Context Providers providers, @Context InitialProperties properties) {
            this.uriInfo = uriInfo;
            this.headers = headers;
            this.request = request;
            this.providers = providers;
            this.properties = properties;
        }

        @GET
        @Path(value="c")
        public String m0() {
            return this.uriInfo.getRequestUri().toString();
        }

        @GET
        @Path(value="d")
        public String m1() {
            List l = this.headers.getRequestHeader("Accept");
            return HeaderHelper.convertToString((Collection)l);
        }

        @GET
        @Path(value="e")
        public String m2() {
            return this.request.getMethod();
        }

        @GET
        @Path(value="f")
        public void m3() {
            TestCase.assertNotNull((Object)this.providers);
        }

        @GET
        @Path(value="g")
        public void m4() {
            TestCase.assertNotNull((Object)this.properties);
            this.properties.setProperty("ws.rs.tmpdir", "null");
        }
    }
}

