/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.MediaTypeHeaderDelegate;

public class MediaTypeTest
extends BaseTest {
    public void testToString() {
        MediaType mime = new MediaType("text", "plain");
        MediaTypeHeaderDelegate hd = new MediaTypeHeaderDelegate();
        MediaTypeTest.assertEquals((String)"text/plain", (String)hd.toString(mime));
    }

    public void testToString2() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("charset", "utf8");
        MediaType mime = new MediaType("text", "plain", p);
        MediaTypeHeaderDelegate hd = new MediaTypeHeaderDelegate();
        MediaTypeTest.assertEquals((String)"text/plain;charset=utf8", (String)hd.toString(mime));
    }

    public void testFromString() throws Exception {
        MediaTypeHeaderDelegate hd = new MediaTypeHeaderDelegate();
        String header = "text";
        MediaType mime = hd.fromString(header);
        MediaTypeTest.assertEquals((int)0, (int)mime.getParameters().size());
        MediaTypeTest.assertEquals((String)"text", (String)mime.getType());
        MediaTypeTest.assertEquals((String)"*", (String)mime.getSubtype());
        header = "text/plain";
        mime = hd.fromString(header);
        MediaTypeTest.assertEquals((int)0, (int)mime.getParameters().size());
        MediaTypeTest.assertEquals((String)"text", (String)mime.getType());
        MediaTypeTest.assertEquals((String)"plain", (String)mime.getSubtype());
    }

    public void testFromString2() throws Exception {
        MediaTypeHeaderDelegate hd = new MediaTypeHeaderDelegate();
        String header = "text;charset =     utf8";
        MediaType mime = hd.fromString(header);
        MediaTypeTest.assertEquals((int)1, (int)mime.getParameters().size());
        MediaTypeTest.assertEquals((String)"utf8", (String)((String)mime.getParameters().get("charset")));
        MediaTypeTest.assertEquals((String)"text", (String)mime.getType());
        MediaTypeTest.assertEquals((String)"*", (String)mime.getSubtype());
        header = "text/plain;   charset   =  utf-8  ;  test=hello";
        mime = hd.fromString(header);
        MediaTypeTest.assertEquals((int)2, (int)mime.getParameters().size());
        MediaTypeTest.assertEquals((String)"utf-8", (String)((String)mime.getParameters().get("charset")));
        MediaTypeTest.assertEquals((String)"hello", (String)((String)mime.getParameters().get("test")));
        MediaTypeTest.assertEquals((String)"text", (String)mime.getType());
        MediaTypeTest.assertEquals((String)"plain", (String)mime.getSubtype());
    }
}

