/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.uri;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.uri.UriComponent;

public class UriComponentTest
extends BaseTest {
    public void testCheckHexCharacters() {
        String str = "%20%23%a0%ag";
        UriComponentTest.assertTrue((boolean)UriComponent.checkHexCharacters((String)str, (int)0));
        UriComponentTest.assertFalse((boolean)UriComponent.checkHexCharacters((String)str, (int)1));
        UriComponentTest.assertTrue((boolean)UriComponent.checkHexCharacters((String)str, (int)3));
        UriComponentTest.assertTrue((boolean)UriComponent.checkHexCharacters((String)str, (int)6));
        UriComponentTest.assertFalse((boolean)UriComponent.checkHexCharacters((String)str, (int)9));
        UriComponentTest.assertFalse((boolean)UriComponent.checkHexCharacters((String)str, (int)11));
    }

    public void testEncodeDecode() {
        String str = "\u041f?\u0440#\u0438 \u0432\u0456\u0442";
        String estr = "%D0%9F%3F%D1%80%23%D0%B8%20%D0%B2%D1%96%D1%82";
        UriComponentTest.assertEquals((String)estr, (String)UriComponent.encode((String)str, (int)2, (boolean)false));
        UriComponentTest.assertEquals((String)str, (String)UriComponent.decode((String)estr, (int)2));
        String estr1 = "%D0%9g%3F%D1%80%23%D0%B8%20%D0%B2%D1%96%D1%82";
        try {
            UriComponent.decode((String)estr1, (int)2);
            UriComponentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        estr1 = "%D0%9F%3F%D1%80%23%D0%B8%20%D0%B2%D1%96%D1%8";
        try {
            UriComponent.decode((String)estr1, (int)2);
            UriComponentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseQueryString() {
        String str = "q1=to%20be%20or%20not%20to%20be&q2=foo&q2=%D0%9F%D1%80%D0%B8%D0%B2%D1%96%D1%82";
        MultivaluedMap m = UriComponent.parseQueryString((String)str, (boolean)false);
        UriComponentTest.assertEquals((int)2, (int)m.size());
        UriComponentTest.assertEquals((int)1, (int)((List)m.get((Object)"q1")).size());
        UriComponentTest.assertEquals((int)2, (int)((List)m.get((Object)"q2")).size());
        m = UriComponent.parseQueryString((String)str, (boolean)true);
        UriComponentTest.assertEquals((int)2, (int)m.size());
        UriComponentTest.assertEquals((int)1, (int)((List)m.get((Object)"q1")).size());
        UriComponentTest.assertEquals((int)2, (int)((List)m.get((Object)"q2")).size());
        UriComponentTest.assertEquals((String)"to be or not to be", (String)((String)((List)m.get((Object)"q1")).get(0)));
        UriComponentTest.assertEquals((String)"foo", (String)((String)((List)m.get((Object)"q2")).get(0)));
        UriComponentTest.assertEquals((String)"\u041f\u0440\u0438\u0432\u0456\u0442", (String)((String)((List)m.get((Object)"q2")).get(1)));
    }

    public void testParsePathSegment() {
        String path = "/to/be/or%20not/to/be;a=foo;b=b%20a%23r";
        List segms = UriComponent.parsePathSegments((String)path, (boolean)true);
        UriComponentTest.assertEquals((int)5, (int)segms.size());
        UriComponentTest.assertEquals((String)"to", (String)((PathSegment)segms.get(0)).getPath());
        UriComponentTest.assertEquals((String)"be", (String)((PathSegment)segms.get(1)).getPath());
        UriComponentTest.assertEquals((String)"or not", (String)((PathSegment)segms.get(2)).getPath());
        UriComponentTest.assertEquals((String)"to", (String)((PathSegment)segms.get(3)).getPath());
        UriComponentTest.assertEquals((String)"be", (String)((PathSegment)segms.get(4)).getPath());
        UriComponentTest.assertEquals((String)"foo", (String)((String)((List)((PathSegment)segms.get(4)).getMatrixParameters().get((Object)"a")).get(0)));
        UriComponentTest.assertEquals((String)"b a#r", (String)((String)((List)((PathSegment)segms.get(4)).getMatrixParameters().get((Object)"b")).get(0)));
    }

    public void testRecognizeEncoding() {
        String str = "to be%23or not to%20be";
        UriComponentTest.assertEquals((String)"to%20be%2523or%20not%20to%2520be", (String)UriComponent.encode((String)str, (int)4, (boolean)false));
        UriComponentTest.assertEquals((String)"to%20be%23or%20not%20to%20be", (String)UriComponent.recognizeEncode((String)str, (int)4, (boolean)false));
    }
}

