/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class InjectAnnotationTest
extends BaseTest {
    public void testInjectFromContainer() throws Exception {
        this.container.registerComponentInstance((Object)InjectableComponent.class.getName(), (Object)new InjectableComponent());
        this.registry(Resource1.class);
        ContainerResponse response = this.launcher.service("GET", "/a", "", null, null, null);
        InjectAnnotationTest.assertEquals((int)200, (int)response.getStatus());
        InjectAnnotationTest.assertEquals((Object)"injected from container", (Object)response.getEntity());
        this.unregistry(Resource1.class);
        this.container.unregisterComponent((Object)InjectableComponent.class.getName());
    }

    public void testInjectFromProvider() throws Exception {
        this.container.registerComponentInstance((Object)Provider90.class.getName(), (Object)new Provider90());
        this.registry(Resource1.class);
        ContainerResponse response = this.launcher.service("GET", "/a", "", null, null, null);
        InjectAnnotationTest.assertEquals((int)200, (int)response.getStatus());
        InjectAnnotationTest.assertEquals((Object)"injected from provider", (Object)response.getEntity());
        this.unregistry(Resource1.class);
        this.container.unregisterComponent((Object)Provider90.class.getName());
    }

    public void testInjectProvider() throws Exception {
        this.container.registerComponentInstance((Object)Provider90.class.getName(), (Object)new Provider90());
        this.registry(Resource2.class);
        ContainerResponse response = this.launcher.service("GET", "/b", "", null, null, null);
        InjectAnnotationTest.assertEquals((int)200, (int)response.getStatus());
        InjectAnnotationTest.assertEquals((Object)"injected from provider", (Object)response.getEntity());
        this.unregistry(Resource2.class);
        this.container.unregisterComponent((Object)Provider90.class.getName());
    }

    public void testInjectWithSetter() throws Exception {
        this.container.registerComponentInstance((Object)InjectableComponent.class.getName(), (Object)new InjectableComponent());
        this.registry(Resource3.class);
        ContainerResponse response = this.launcher.service("GET", "/a", "", null, null, null);
        InjectAnnotationTest.assertEquals((int)200, (int)response.getStatus());
        InjectAnnotationTest.assertEquals((Object)"injected from container", (Object)response.getEntity());
        this.unregistry(Resource3.class);
        this.container.unregisterComponent((Object)InjectableComponent.class.getName());
    }

    public static class InjectableComponent
    implements GenericIngectable<String> {
        public String message = "injected from container";
    }

    @Path(value="a")
    public static class Resource1 {
        @Inject
        private GenericIngectable<String> injected;

        @GET
        public String m() {
            TestCase.assertNotNull(this.injected);
            return ((InjectableComponent)this.injected).message;
        }
    }

    public static class Provider90
    implements Provider<GenericIngectable<String>> {
        public GenericIngectable<String> get() {
            InjectableComponent injectable = new InjectableComponent();
            injectable.message = "injected from provider";
            return injectable;
        }
    }

    @Path(value="b")
    public static class Resource2 {
        @Inject
        private Provider<GenericIngectable<String>> injected;

        @GET
        public String m() {
            TestCase.assertNotNull(this.injected);
            InjectableComponent inst = (InjectableComponent)this.injected.get();
            return inst.message;
        }
    }

    @Path(value="a")
    public static class Resource3 {
        @Inject
        private GenericIngectable<String> injected;
        private boolean injectedThroughSetter = false;

        @GET
        public String m() {
            TestCase.assertNotNull(this.injected);
            TestCase.assertTrue((boolean)this.injectedThroughSetter);
            return ((InjectableComponent)this.injected).message;
        }

        public void setInjected(GenericIngectable<String> injected) {
            this.injectedThroughSetter = true;
            this.injected = injected;
        }
    }

    public static interface GenericIngectable<T> {
    }
}

