/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.test.mock.MockHttpServletRequest;

public class ResponseFilterTest
extends BaseTest {
    public void testFilter() throws Exception {
        Resource1 r = new Resource1();
        this.registry(r);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("/a", null, 0, "POST", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("POST", "/a", "", null, null, envctx);
        ResponseFilterTest.assertEquals((int)204, (int)resp.getStatus());
        this.providers.addResponseFilter((ResponseFilter)new ResponseFilter2());
        resp = this.launcher.service("POST", "/a", "", null, null, envctx);
        ResponseFilterTest.assertEquals((int)204, (int)resp.getStatus());
        this.providers.addResponseFilter(ResponseFilter1.class);
        resp = this.launcher.service("POST", "/a", "", null, null, envctx);
        ResponseFilterTest.assertEquals((int)200, (int)resp.getStatus());
        ResponseFilterTest.assertEquals((String)"text/plain", (String)resp.getContentType().toString());
        ResponseFilterTest.assertEquals((Object)"to be or not to be", (Object)resp.getEntity());
        this.unregistry(r);
    }

    public void testFilter2() throws Exception {
        Resource1 r = new Resource1();
        this.registry(r);
        ContainerResponse resp = this.launcher.service("POST", "/a/b/c/d/e", "", null, null, null);
        ResponseFilterTest.assertEquals((int)200, (int)resp.getStatus());
        ResponseFilterTest.assertEquals((String)"text/plain", (String)resp.getContentType().toString());
        ResponseFilterTest.assertEquals((Object)"{\"name\":\"andrew\", \"password\":\"hello\"}", (Object)resp.getEntity());
        this.providers.addResponseFilter((ResponseFilter)new ResponseFilter2());
        resp = this.launcher.service("POST", "/a/b/c/d/e", "", null, null, null);
        ResponseFilterTest.assertEquals((int)200, (int)resp.getStatus());
        ResponseFilterTest.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        ResponseFilterTest.assertEquals((Object)"{\"name\":\"andrew\", \"password\":\"hello\"}", (Object)resp.getEntity());
        this.unregistry(r);
    }

    @Path(value="a")
    public static class Resource1 {
        @POST
        public void m0() {
        }

        @POST
        @Path(value="b/c/d/e")
        @Produces(value={"text/plain"})
        public String m1() {
            return "{\"name\":\"andrew\", \"password\":\"hello\"}";
        }
    }

    @Path(value="a/b/c/{x:.*}")
    @Filter
    public static class ResponseFilter2
    implements ResponseFilter {
        public void doFilter(GenericContainerResponse response) {
            response.setResponse(Response.status((int)response.getStatus()).entity(response.getEntity()).type("application/json").build());
        }
    }

    @Filter
    public static class ResponseFilter1
    implements ResponseFilter {
        @Context
        private UriInfo uriInfo;
        @Context
        private HttpHeaders httpHeaders;
        private Providers providers;
        private HttpServletRequest httpRequest;
        private ResourceBinder binder;

        public ResponseFilter1(@Context Providers providers, @Context HttpServletRequest httpRequest, ResourceBinder binder) {
            this.providers = providers;
            this.httpRequest = httpRequest;
            this.binder = binder;
        }

        public void doFilter(GenericContainerResponse response) {
            if (this.uriInfo != null && this.httpHeaders != null && this.providers != null && this.httpRequest != null && this.binder != null) {
                response.setResponse(Response.status((int)200).entity((Object)"to be or not to be").type("text/plain").build());
            }
        }
    }
}

