/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.generated.Book;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class JsonEntityTest
extends BaseTest {
    private static String jsonBook = "{\"title\":\"Hamlet\", \"author\":\"William Shakespeare\", \"sendByPost\":true}";
    private static String jsonArray = "[{\"title\":\"Hamlet\", \"author\":\"William Shakespeare\", \"sendByPost\":true},{\"title\":\"Collected Stories\", \"author\":\"Gabriel Garcia Marquez\", \"sendByPost\":true}]";
    private static String jsonMap = "{\"12345\":{\"title\":\"Hamlet\", \"author\":\"William Shakespeare\", \"sendByPost\":true},\"54321\":{\"title\":\"Collected Stories\", \"author\":\"Gabriel Garcia Marquez\", \"sendByPost\":true}}";
    private byte[] jsonBookData;
    private byte[] jsonArrayData;
    private byte[] jsonMapData;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.jsonBookData = jsonBook.getBytes("UTF-8");
        this.jsonArrayData = jsonArray.getBytes("UTF-8");
        this.jsonMapData = jsonMap.getBytes("UTF-8");
    }

    public void testJsonEntityBean() throws Exception {
        ResourceBook r1 = new ResourceBook();
        this.registry(r1);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + this.jsonBookData.length));
        JsonEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/", "", (Map)h, this.jsonBookData, null).getStatus());
        this.unregistry(r1);
    }

    public void testJsonEntityArray() throws Exception {
        ResourceBookArray r1 = new ResourceBookArray();
        this.registry(r1);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + this.jsonArrayData.length));
        JsonEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/", "", (Map)h, this.jsonArrayData, null).getStatus());
        this.unregistry(r1);
    }

    public void testJsonEntityCollection() throws Exception {
        ResourceBookCollection r1 = new ResourceBookCollection();
        this.registry(r1);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + this.jsonArrayData.length));
        JsonEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/", "", (Map)h, this.jsonArrayData, null).getStatus());
        this.unregistry(r1);
    }

    public void testJsonEntityMap() throws Exception {
        ResourceBookMap r1 = new ResourceBookMap();
        this.registry(r1);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + this.jsonMapData.length));
        JsonEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/", "", (Map)h, this.jsonMapData, null).getStatus());
        this.unregistry(r1);
    }

    public void testJsonEntityString() throws Exception {
        ResourceString r1 = new ResourceString();
        this.registry(r1);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + this.jsonBookData.length));
        JsonEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/", "", (Map)h, this.jsonBookData, null).getStatus());
        this.unregistry(r1);
    }

    public void testJsonReturnBean() throws Exception {
        ResourceBook2 r2 = new ResourceBook2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/json");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        JsonParserImpl parser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        Book book = (Book)ObjectBuilder.createObject(Book.class, (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)book.getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)book.getAuthor());
        JsonEntityTest.assertTrue((boolean)book.isSendByPost());
        writer.reset();
        handler.reset();
        response = this.launcher.service("POST", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        book = (Book)ObjectBuilder.createObject(Book.class, (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)book.getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)book.getAuthor());
        JsonEntityTest.assertTrue((boolean)book.isSendByPost());
        this.unregistry(r2);
    }

    public void testJsonReturnBeanArray() throws Exception {
        ResourceBookArray2 r2 = new ResourceBookArray2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/json");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        JsonParserImpl parser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        Book[] book = (Book[])ObjectBuilder.createArray(new Book[0].getClass(), (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)book[0].getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)book[0].getAuthor());
        JsonEntityTest.assertTrue((boolean)book[0].isSendByPost());
        JsonEntityTest.assertEquals((String)"Collected Stories", (String)book[1].getTitle());
        JsonEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)book[1].getAuthor());
        JsonEntityTest.assertTrue((boolean)book[1].isSendByPost());
        writer.reset();
        handler.reset();
        response = this.launcher.service("POST", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        book = (Book[])ObjectBuilder.createArray(new Book[0].getClass(), (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)book[0].getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)book[0].getAuthor());
        JsonEntityTest.assertTrue((boolean)book[0].isSendByPost());
        JsonEntityTest.assertEquals((String)"Collected Stories", (String)book[1].getTitle());
        JsonEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)book[1].getAuthor());
        JsonEntityTest.assertTrue((boolean)book[1].isSendByPost());
        this.unregistry(r2);
    }

    public void testJsonReturnBeanCollection() throws Exception {
        ResourceBookCollection2 r2 = new ResourceBookCollection2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/json");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        JsonParserImpl parser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        ParameterizedType genericType = (ParameterizedType)new ArrayList<Book>(){}.getClass().getGenericSuperclass();
        List book = (List)ObjectBuilder.createCollection(List.class, (Type)genericType, (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get(0)).getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get(0)).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get(0)).isSendByPost());
        JsonEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get(1)).getTitle());
        JsonEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get(1)).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get(1)).isSendByPost());
        writer.reset();
        handler.reset();
        response = this.launcher.service("POST", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        book = (List)ObjectBuilder.createCollection(List.class, (Type)genericType, (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get(0)).getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get(0)).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get(0)).isSendByPost());
        JsonEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get(1)).getTitle());
        JsonEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get(1)).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get(1)).isSendByPost());
        this.unregistry(r2);
    }

    public void testJsonReturnBeanMap() throws Exception {
        ResourceBookMap2 r2 = new ResourceBookMap2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/json");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        JsonParserImpl parser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        ParameterizedType genericType = (ParameterizedType)new HashMap<String, Book>(){}.getClass().getGenericSuperclass();
        Map book = ObjectBuilder.createObject(Map.class, (Type)genericType, (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get("12345")).getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get("12345")).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get("12345")).isSendByPost());
        JsonEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get("54321")).getTitle());
        JsonEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get("54321")).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get("54321")).isSendByPost());
        writer.reset();
        handler.reset();
        response = this.launcher.service("POST", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody()), (JsonHandler)handler);
        book = ObjectBuilder.createObject(Map.class, (Type)genericType, (JsonValue)handler.getJsonObject());
        JsonEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get("12345")).getTitle());
        JsonEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get("12345")).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get("12345")).isSendByPost());
        JsonEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get("54321")).getTitle());
        JsonEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get("54321")).getAuthor());
        JsonEntityTest.assertTrue((boolean)((Book)book.get("54321")).isSendByPost());
        this.unregistry(r2);
    }

    public void testJsonReturnString() throws Exception {
        ResourceString2 r2 = new ResourceString2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/json");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        JsonEntityTest.assertEquals((Object)jsonBook, (Object)response.getEntity());
        writer.reset();
        response = this.launcher.service("POST", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonEntityTest.assertEquals((String)"application/json", (String)response.getContentType().toString());
        JsonEntityTest.assertEquals((Object)jsonBook, (Object)response.getEntity());
        this.unregistry(r2);
    }

    @Path(value="/")
    public static class ResourceBook {
        @POST
        @Consumes(value={"application/json"})
        public void m1(Book book) {
            TestCase.assertEquals((String)"Hamlet", (String)book.getTitle());
            TestCase.assertEquals((String)"William Shakespeare", (String)book.getAuthor());
            TestCase.assertTrue((boolean)book.isSendByPost());
        }
    }

    @Path(value="/")
    public static class ResourceBookArray {
        @POST
        @Consumes(value={"application/json"})
        public void m1(Book[] b) {
            TestCase.assertEquals((String)"Hamlet", (String)b[0].getTitle());
            TestCase.assertEquals((String)"William Shakespeare", (String)b[0].getAuthor());
            TestCase.assertTrue((boolean)b[0].isSendByPost());
            TestCase.assertEquals((String)"Collected Stories", (String)b[1].getTitle());
            TestCase.assertEquals((String)"Gabriel Garcia Marquez", (String)b[1].getAuthor());
            TestCase.assertTrue((boolean)b[1].isSendByPost());
        }
    }

    @Path(value="/")
    public static class ResourceBookCollection {
        @POST
        @Consumes(value={"application/json"})
        public void m1(List<Book> b) {
            TestCase.assertEquals((String)"Hamlet", (String)b.get(0).getTitle());
            TestCase.assertEquals((String)"William Shakespeare", (String)b.get(0).getAuthor());
            TestCase.assertTrue((boolean)b.get(0).isSendByPost());
            TestCase.assertEquals((String)"Collected Stories", (String)b.get(1).getTitle());
            TestCase.assertEquals((String)"Gabriel Garcia Marquez", (String)b.get(1).getAuthor());
            TestCase.assertTrue((boolean)b.get(1).isSendByPost());
        }
    }

    @Path(value="/")
    public static class ResourceBookMap {
        @POST
        @Consumes(value={"application/json"})
        public void m1(Map<String, Book> b) {
            TestCase.assertEquals((String)"Hamlet", (String)b.get("12345").getTitle());
            TestCase.assertEquals((String)"William Shakespeare", (String)b.get("12345").getAuthor());
            TestCase.assertTrue((boolean)b.get("12345").isSendByPost());
            TestCase.assertEquals((String)"Collected Stories", (String)b.get("54321").getTitle());
            TestCase.assertEquals((String)"Gabriel Garcia Marquez", (String)b.get("54321").getAuthor());
            TestCase.assertTrue((boolean)b.get("54321").isSendByPost());
        }
    }

    @Path(value="/")
    public static class ResourceString {
        @POST
        @Consumes(value={"application/json"})
        public void m1(String b) {
            TestCase.assertEquals((String)jsonBook, (String)b);
        }
    }

    @Path(value="/")
    public static class ResourceBook2 {
        @GET
        @Produces(value={"application/json"})
        public Book m1() {
            Book book = new Book();
            book.setTitle("Hamlet");
            book.setAuthor("William Shakespeare");
            book.setSendByPost(true);
            return book;
        }

        @POST
        public Book m2() {
            return this.m1();
        }
    }

    @Path(value="/")
    public static class ResourceBookArray2 {
        @GET
        @Produces(value={"application/json"})
        public Book[] m1() {
            return this.createArray();
        }

        @POST
        public Book[] m2() {
            return this.createArray();
        }

        private Book[] createArray() {
            Book book1 = new Book();
            book1.setTitle("Hamlet");
            book1.setAuthor("William Shakespeare");
            book1.setSendByPost(true);
            Book book2 = new Book();
            book2.setTitle("Collected Stories");
            book2.setAuthor("Gabriel Garcia Marquez");
            book2.setSendByPost(true);
            return new Book[]{book1, book2};
        }
    }

    @Path(value="/")
    public static class ResourceBookCollection2 {
        @GET
        @Produces(value={"application/json"})
        public List<Book> m1() {
            return this.createCollection();
        }

        @POST
        public List<Book> m2() {
            return this.createCollection();
        }

        private List<Book> createCollection() {
            Book book1 = new Book();
            book1.setTitle("Hamlet");
            book1.setAuthor("William Shakespeare");
            book1.setSendByPost(true);
            Book book2 = new Book();
            book2.setTitle("Collected Stories");
            book2.setAuthor("Gabriel Garcia Marquez");
            book2.setSendByPost(true);
            return Arrays.asList(book1, book2);
        }
    }

    @Path(value="/")
    public static class ResourceBookMap2 {
        @GET
        @Produces(value={"application/json"})
        public Map<String, Book> m1() {
            return this.createMap();
        }

        @POST
        public Map<String, Book> m2() {
            return this.createMap();
        }

        private Map<String, Book> createMap() {
            Book book1 = new Book();
            book1.setTitle("Hamlet");
            book1.setAuthor("William Shakespeare");
            book1.setSendByPost(true);
            Book book2 = new Book();
            book2.setTitle("Collected Stories");
            book2.setAuthor("Gabriel Garcia Marquez");
            book2.setSendByPost(true);
            HashMap<String, Book> m = new HashMap<String, Book>();
            m.put("12345", book1);
            m.put("54321", book2);
            return m;
        }
    }

    @Path(value="/")
    public static class ResourceString2 {
        @GET
        @Produces(value={"application/json"})
        public String m1() {
            return jsonBook;
        }

        @POST
        public Response m2() {
            return Response.ok((Object)jsonBook).type("application/json").build();
        }
    }
}

