/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class JsonpEntityTest
extends BaseTest {
    private static final String JS_FILE_CONTENT = "console.log('Test JS File')";
    private static String jsonBook = "{\"title\":\"Hamlet\", \"author\":\"William Shakespeare\", \"sendByPost\":true}";

    public void testJsonReturnBean() throws Exception {
        ContainerResponse response;
        ResourceBook r2 = new ResourceBook();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/javascript");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        try {
            response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
            JsonpEntityTest.fail((String)"An IOException is expected as the parameter jsonp has not been set");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            response = this.launcher.service("GET", "/?param=foo", "", (Map)h, null, (ContainerResponseWriter)writer, null);
            JsonpEntityTest.fail((String)"An IOException is expected as the parameter jsonp has not been set");
        }
        catch (Exception exception) {
            // empty catch block
        }
        response = this.launcher.service("GET", "/?jsonp=functionName", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonpEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonpEntityTest.assertEquals((String)"application/javascript", (String)response.getContentType().toString());
        Book book = (Book)response.getEntity();
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)book.getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)book.getAuthor());
        JsonpEntityTest.assertTrue((boolean)book.isSendByPost());
        JsonDefaultHandler handler = this.testBody(writer, "functionName(");
        book = (Book)ObjectBuilder.createObject(Book.class, (JsonValue)handler.getJsonObject());
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)book.getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)book.getAuthor());
        JsonpEntityTest.assertTrue((boolean)book.isSendByPost());
        this.unregistry(r2);
    }

    private JsonDefaultHandler testBody(ByteArrayContainerResponseWriter writer, String start) throws JsonException {
        byte[] body = writer.getBody();
        byte[] startWith = start.getBytes();
        for (int i = 0; i < startWith.length; ++i) {
            JsonpEntityTest.assertEquals((byte)startWith[i], (byte)body[i]);
        }
        byte[] endWith = ");".getBytes();
        for (int i = 0; i < endWith.length; ++i) {
            JsonpEntityTest.assertEquals((byte)endWith[i], (byte)body[body.length - endWith.length + i]);
        }
        JsonParserImpl parser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        parser.parse((InputStream)new ByteArrayInputStream(writer.getBody(), startWith.length, body.length - endWith.length - startWith.length), (JsonHandler)handler);
        return handler;
    }

    public void testJsonReturnBeanArray() throws Exception {
        ResourceBookArray r2 = new ResourceBookArray();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"text/javascript");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/?jsonp=obj.functionName", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonpEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonpEntityTest.assertEquals((String)"text/javascript", (String)response.getContentType().toString());
        Book[] book = (Book[])response.getEntity();
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)book[0].getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)book[0].getAuthor());
        JsonpEntityTest.assertTrue((boolean)book[0].isSendByPost());
        JsonpEntityTest.assertEquals((String)"Collected Stories", (String)book[1].getTitle());
        JsonpEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)book[1].getAuthor());
        JsonpEntityTest.assertTrue((boolean)book[1].isSendByPost());
        JsonDefaultHandler handler = this.testBody(writer, "obj.functionName(");
        book = (Book[])ObjectBuilder.createArray(new Book[0].getClass(), (JsonValue)handler.getJsonObject());
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)book[0].getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)book[0].getAuthor());
        JsonpEntityTest.assertTrue((boolean)book[0].isSendByPost());
        JsonpEntityTest.assertEquals((String)"Collected Stories", (String)book[1].getTitle());
        JsonpEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)book[1].getAuthor());
        JsonpEntityTest.assertTrue((boolean)book[1].isSendByPost());
        this.unregistry(r2);
    }

    public void testTextJavascriptReturnText() throws Exception {
        TextJavascript r2 = new TextJavascript();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"text/javascript");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonpEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonpEntityTest.assertEquals((String)"text/javascript", (String)response.getContentType().toString());
        String js = (String)response.getEntity();
        JsonpEntityTest.assertEquals((String)JS_FILE_CONTENT, (String)js);
        this.unregistry(r2);
    }

    public void testJsonReturnBeanCollection() throws Exception {
        ResourceBookCollection r2 = new ResourceBookCollection();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/json-p");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/?jsonp=obj%5B%22function-name%22%5D", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonpEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonpEntityTest.assertEquals((String)"application/json-p", (String)response.getContentType().toString());
        List book = (List)response.getEntity();
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get(0)).getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get(0)).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get(0)).isSendByPost());
        JsonpEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get(1)).getTitle());
        JsonpEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get(1)).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get(1)).isSendByPost());
        JsonDefaultHandler handler = this.testBody(writer, "obj[\"function-name\"](");
        ParameterizedType genericType = (ParameterizedType)new ArrayList<Book>(){}.getClass().getGenericSuperclass();
        book = (List)ObjectBuilder.createCollection(List.class, (Type)genericType, (JsonValue)handler.getJsonObject());
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get(0)).getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get(0)).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get(0)).isSendByPost());
        JsonpEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get(1)).getTitle());
        JsonpEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get(1)).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get(1)).isSendByPost());
        this.unregistry(r2);
    }

    public void testJsonReturnBeanMap() throws Exception {
        ResourceBookMap r2 = new ResourceBookMap();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"text/json-p");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/?jsonp=foo", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonpEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonpEntityTest.assertEquals((String)"text/json-p", (String)response.getContentType().toString());
        Map book = (Map)response.getEntity();
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get("12345")).getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get("12345")).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get("12345")).isSendByPost());
        JsonpEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get("54321")).getTitle());
        JsonpEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get("54321")).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get("54321")).isSendByPost());
        ParameterizedType genericType = (ParameterizedType)new HashMap<String, Book>(){}.getClass().getGenericSuperclass();
        JsonDefaultHandler handler = this.testBody(writer, "foo(");
        book = ObjectBuilder.createObject(Map.class, (Type)genericType, (JsonValue)handler.getJsonObject());
        JsonpEntityTest.assertEquals((String)"Hamlet", (String)((Book)book.get("12345")).getTitle());
        JsonpEntityTest.assertEquals((String)"William Shakespeare", (String)((Book)book.get("12345")).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get("12345")).isSendByPost());
        JsonpEntityTest.assertEquals((String)"Collected Stories", (String)((Book)book.get("54321")).getTitle());
        JsonpEntityTest.assertEquals((String)"Gabriel Garcia Marquez", (String)((Book)book.get("54321")).getAuthor());
        JsonpEntityTest.assertTrue((boolean)((Book)book.get("54321")).isSendByPost());
        this.unregistry(r2);
    }

    public void testJsonReturnString() throws Exception {
        ResourceString r2 = new ResourceString();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/javascript");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/?jsonp=callbackFunction", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JsonpEntityTest.assertEquals((int)200, (int)response.getStatus());
        JsonpEntityTest.assertEquals((String)"application/javascript", (String)response.getContentType().toString());
        JsonpEntityTest.assertEquals((Object)jsonBook, (Object)response.getEntity());
        JsonpEntityTest.assertEquals((String)("callbackFunction(" + jsonBook + ");"), (String)new String(writer.getBody()));
        this.unregistry(r2);
    }

    @Path(value="/")
    public static class ResourceBook {
        @GET
        @Produces(value={"application/javascript"})
        public Book m1() {
            Book book = new Book();
            book.setTitle("Hamlet");
            book.setAuthor("William Shakespeare");
            book.setSendByPost(true);
            return book;
        }
    }

    public static class Book {
        private String title;
        private String author;
        private boolean sendByPost;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public boolean isSendByPost() {
            return this.sendByPost;
        }

        public void setSendByPost(boolean sendByPost) {
            this.sendByPost = sendByPost;
        }
    }

    @Path(value="/")
    public static class ResourceBookArray {
        @GET
        @Produces(value={"text/javascript"})
        public Book[] m1() {
            Book book1 = new Book();
            book1.setTitle("Hamlet");
            book1.setAuthor("William Shakespeare");
            book1.setSendByPost(true);
            Book book2 = new Book();
            book2.setTitle("Collected Stories");
            book2.setAuthor("Gabriel Garcia Marquez");
            book2.setSendByPost(true);
            return new Book[]{book1, book2};
        }
    }

    @Path(value="/")
    public static class TextJavascript {
        @GET
        @Produces(value={"text/javascript"})
        public String m1() {
            return JsonpEntityTest.JS_FILE_CONTENT;
        }
    }

    @Path(value="/")
    public static class ResourceBookCollection {
        @GET
        @Produces(value={"application/json-p"})
        public List<Book> m1() {
            Book book1 = new Book();
            book1.setTitle("Hamlet");
            book1.setAuthor("William Shakespeare");
            book1.setSendByPost(true);
            Book book2 = new Book();
            book2.setTitle("Collected Stories");
            book2.setAuthor("Gabriel Garcia Marquez");
            book2.setSendByPost(true);
            return Arrays.asList(book1, book2);
        }
    }

    @Path(value="/")
    public static class ResourceBookMap {
        @GET
        @Produces(value={"text/json-p"})
        public Map<String, Book> m1() {
            Book book1 = new Book();
            book1.setTitle("Hamlet");
            book1.setAuthor("William Shakespeare");
            book1.setSendByPost(true);
            Book book2 = new Book();
            book2.setTitle("Collected Stories");
            book2.setAuthor("Gabriel Garcia Marquez");
            book2.setSendByPost(true);
            HashMap<String, Book> m = new HashMap<String, Book>();
            m.put("12345", book1);
            m.put("54321", book2);
            return m;
        }
    }

    @Path(value="/")
    public static class ResourceString {
        @GET
        @Produces(value={"application/javascript"})
        public String m1() {
            return jsonBook;
        }
    }
}

