/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.rest.BaseTest;

public class StringEntityProviderTest
extends BaseTest {
    private static final String TEST_CYR = "\u041f\u0440\u0438\u0432\u0456\u0442";
    private MediaType mediaType;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, String> p = new HashMap<String, String>(1);
        p.put("charset", "windows-1251");
        this.mediaType = new MediaType("text", "plain", p);
    }

    public void testRead() throws IOException {
        MessageBodyReader reader = this.providers.getMessageBodyReader(String.class, null, null, this.mediaType);
        byte[] data = TEST_CYR.getBytes("windows-1251");
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        String res = (String)reader.readFrom(String.class, String.class, null, this.mediaType, null, (InputStream)in);
        StringEntityProviderTest.assertTrue((boolean)TEST_CYR.equals(res));
        this.mediaType = new MediaType("text", "plain");
        in = new ByteArrayInputStream(data);
        res = (String)reader.readFrom(String.class, null, null, this.mediaType, null, (InputStream)in);
        StringEntityProviderTest.assertFalse((boolean)TEST_CYR.equals(res));
    }

    public void testWrite() throws IOException {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(String.class, null, null, this.mediaType);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.writeTo((Object)TEST_CYR, String.class, String.class, null, this.mediaType, null, (OutputStream)out);
        String res = out.toString("windows-1251");
        StringEntityProviderTest.assertTrue((boolean)TEST_CYR.equals(res));
        out.reset();
        this.mediaType = new MediaType("text", "plain");
        writer.writeTo((Object)TEST_CYR, String.class, String.class, null, this.mediaType, null, (OutputStream)out);
        res = out.toString("windows-1251");
        StringEntityProviderTest.assertFalse((boolean)TEST_CYR.equals(res));
    }
}

