/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public final class InputHeadersMap
extends HashMap<String, List<String>>
implements MultivaluedMap<String, String> {
    private static final long serialVersionUID = -4181622019478475004L;
    private transient Set<Map.Entry<String, List<String>>> entrySet;
    private transient Set<String> keySet;
    private transient Set<List<String>> valueSet;
    private final Map<String, List<String>> m;

    public InputHeadersMap(Map<String, List<String>> m) {
        if (m == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        this.m = new HashMap<String, List<String>>(m.size());
        for (Map.Entry<String, List<String>> e : m.entrySet()) {
            this.m.put(e.getKey().toLowerCase(), Collections.unmodifiableList(e.getValue()));
        }
    }

    @Override
    public List<String> get(Object o) {
        if (o != null) {
            return this.m.get(((String)o).toLowerCase());
        }
        return this.m.get(o);
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        if (this.entrySet == null) {
            this.createEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.unmodifiableSet(this.m.keySet());
        }
        return this.keySet;
    }

    @Override
    public Set<List<String>> values() {
        if (this.valueSet == null) {
            this.createValues();
        }
        return this.valueSet;
    }

    @Override
    public List<String> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> put(String k, List<String> v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    public void add(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public String getFirst(String key) {
        Object list = this.get(key);
        return list != null && list.size() > 0 ? (String)list.get(0) : null;
    }

    public void putSingle(String key, String value) {
        throw new UnsupportedOperationException();
    }

    private void createEntrySet() {
        this.entrySet = new AbstractReadOnlySet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new AbstractReadOnlyIterator<Map.Entry<String, List<String>>>(){
                    private final Iterator<Map.Entry<String, List<String>>> i;
                    {
                        this.i = InputHeadersMap.this.m.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<String, List<String>> next() {
                        return new AbstractReadOnlyEntry<String, List<String>>(){
                            private final Map.Entry<String, List<String>> e;
                            {
                                this.e = i.next();
                            }

                            @Override
                            public String getKey() {
                                return this.e.getKey();
                            }

                            @Override
                            public List<String> getValue() {
                                return this.e.getValue();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return InputHeadersMap.this.m.size();
            }
        };
    }

    private void createValues() {
        this.valueSet = new AbstractReadOnlySet<List<String>>(){

            @Override
            public Iterator<List<String>> iterator() {
                return new AbstractReadOnlyIterator<List<String>>(){
                    private final Iterator<String> i;
                    {
                        this.i = InputHeadersMap.this.m.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public List<String> next() {
                        if (!this.i.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return InputHeadersMap.this.m.get(this.i.next());
                    }
                };
            }

            @Override
            public int size() {
                return InputHeadersMap.this.m.size();
            }
        };
    }

    private abstract class AbstractReadOnlySet<T>
    extends AbstractSet<T> {
        private AbstractReadOnlySet(InputHeadersMap inputHeadersMap) {
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class AbstractReadOnlyIterator<T>
    implements Iterator<T> {
        private AbstractReadOnlyIterator(InputHeadersMap inputHeadersMap) {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class AbstractReadOnlyEntry<K, V>
    implements Map.Entry<K, V> {
        private AbstractReadOnlyEntry(InputHeadersMap inputHeadersMap) {
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

