/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.text.ParseException;
import java.util.Map;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.HeaderParameterParser;

public class HeaderParameterParserTest
extends BaseTest {
    public void testSimple() throws ParseException {
        HeaderParameterParser hp = new HeaderParameterParser();
        String src = "text/plain;foo=bar";
        Map m = hp.parse(src);
        HeaderParameterParserTest.assertEquals((String)"bar", (String)((String)m.get("foo")));
        src = "text/plain;foo=\"bar\"";
        m = hp.parse(src);
        HeaderParameterParserTest.assertEquals((String)"bar", (String)((String)m.get("foo")));
    }

    public void testQuoted() throws ParseException {
        HeaderParameterParser hp = new HeaderParameterParser();
        String src = "text/plain;foo=\"\\\"he\\\";llo\\\"\"   ;  ba r  =  f o o       ; foo2";
        Map m = hp.parse(src);
        HeaderParameterParserTest.assertEquals((int)3, (int)m.size());
        HeaderParameterParserTest.assertEquals((String)"\"he\";llo\"", (String)((String)m.get("foo")));
        HeaderParameterParserTest.assertEquals((String)"f o o", (String)((String)m.get("ba r")));
        HeaderParameterParserTest.assertNull(m.get("foo2"));
        src = "text/plain;bar=\"foo\" \t; bar2; test=\"\\a\\b\\c\\\"\"   ;  foo=bar";
        m = hp.parse(src);
        HeaderParameterParserTest.assertEquals((int)4, (int)m.size());
        HeaderParameterParserTest.assertEquals((String)"foo", (String)((String)m.get("bar")));
        HeaderParameterParserTest.assertEquals((String)"\\a\\b\\c\"", (String)((String)m.get("test")));
        HeaderParameterParserTest.assertEquals((String)"bar", (String)((String)m.get("foo")));
        HeaderParameterParserTest.assertNull(m.get("bar2"));
    }
}

