/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import junit.framework.TestCase;
import org.apache.commons.fileupload2.core.FileItem;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.test.mock.MockHttpServletRequest;

public class FormEntityTest
extends BaseTest {
    private static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><data>hello world</data></root>";
    private static final String JSON_DATA = "{\"data\":\"hello world\"}";

    public void testFormEntity() throws Exception {
        Resource1 r1 = new Resource1();
        this.registry(r1);
        byte[] data = "foo=to%20be%20or%20not%20to%20be&bar=hello%20world".getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/x-www-form-urlencoded");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        FormEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/a", "", (Map)h, data, null).getStatus());
        FormEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/b", "", (Map)h, data, null).getStatus());
        this.unregistry(r1);
    }

    public void testMultipartForm() throws Exception {
        Resource2 r2 = new Resource2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(out);
        w.write("--abcdef\r\nContent-Disposition: form-data; name=\"xml-file\"; filename=\"foo.xml\"\r\nContent-Type: text/xml\r\n\r\n<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><data>hello world</data></root>\r\n--abcdef\r\nContent-Disposition: form-data; name=\"json-file\"; filename=\"foo.json\"\r\nContent-Type: application/json\r\n\r\n{\"data\":\"hello world\"}\r\n--abcdef\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nto be or not to be\r\n--abcdef--\r\n");
        w.flush();
        h.putSingle((Object)"content-type", (Object)"multipart/form-data; boundary=abcdef");
        byte[] data = out.toByteArray();
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("/", (InputStream)new ByteArrayInputStream(data), data.length, "POST", (Map)h);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        FormEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/", "", (Map)h, data, envctx).getStatus());
        this.unregistry(r2);
    }

    @Path(value="/")
    public static class Resource1 {
        @POST
        @Path(value="a")
        @Consumes(value={"application/x-www-form-urlencoded"})
        public void m1(@FormParam(value="foo") String foo, @FormParam(value="bar") String bar, MultivaluedMap<String, String> form) {
            TestCase.assertEquals((String)foo, (String)((String)form.getFirst((Object)"foo")));
            TestCase.assertEquals((String)bar, (String)((String)form.getFirst((Object)"bar")));
        }

        @POST
        @Path(value="b")
        @Consumes(value={"application/x-www-form-urlencoded"})
        public void m2(MultivaluedMap<String, String> form) {
            TestCase.assertEquals((String)"to be or not to be", (String)((String)form.getFirst((Object)"foo")));
            TestCase.assertEquals((String)"hello world", (String)((String)form.getFirst((Object)"bar")));
        }
    }

    @Path(value="/")
    public static class Resource2 {
        private Iterator<FileItemTester> pattern;

        public Resource2() {
            ArrayList<FileItemTester> l = new ArrayList<FileItemTester>(3);
            l.add(new FileItemTester(this, "text/xml", false, "xml-file", "foo.xml", FormEntityTest.XML_DATA));
            l.add(new FileItemTester(this, "application/json", false, "json-file", "foo.json", FormEntityTest.JSON_DATA));
            l.add(new FileItemTester(this, null, true, "field", null, "to be or not to be"));
            this.pattern = l.iterator();
        }

        @POST
        @Consumes(value={"multipart/*"})
        public void m9(Iterator<FileItem> iter) throws Exception {
            while (iter.hasNext()) {
                if (!this.pattern.hasNext()) {
                    TestCase.fail((String)"Wrong number of parsed items");
                }
                FileItem fi = iter.next();
                FileItemTester fit = this.pattern.next();
                TestCase.assertEquals((String)fit.getContentType(), (String)fi.getContentType());
                TestCase.assertEquals((boolean)fit.isFormField(), (boolean)fi.isFormField());
                TestCase.assertEquals((String)fit.getFieldName(), (String)fi.getFieldName());
                TestCase.assertEquals((String)fit.getName(), (String)fi.getName());
                TestCase.assertEquals((String)fit.getString(), (String)fi.getString());
            }
        }

        private class FileItemTester {
            private boolean isFormField;
            private String contentType;
            private String name;
            private String fieldName;
            private String string;

            public FileItemTester(Resource2 resource2, String contentType, boolean isFormField, String fieldName, String name, String string) {
                this.contentType = contentType;
                this.isFormField = isFormField;
                this.fieldName = fieldName;
                this.name = name;
                this.string = string;
            }

            public String getContentType() {
                return this.contentType;
            }

            public boolean isFormField() {
                return this.isFormField;
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public String getName() {
                return this.name;
            }

            public String getString() {
                return this.string;
            }
        }
    }
}

