/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.List;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.AcceptToken;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

public class AcceptTokenTest
extends BaseTest {
    public void testListAcceptCharset() {
        String cs = null;
        List l = HeaderHelper.createAcceptedCharsetList(cs);
        AcceptTokenTest.assertEquals((int)1, (int)l.size());
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(0)).getToken(), (String)"*");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        cs = "";
        l = HeaderHelper.createAcceptedCharsetList((String)cs);
        AcceptTokenTest.assertEquals((int)1, (int)l.size());
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(0)).getToken(), (String)"*");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        cs = "Windows-1251,utf-8; q   =0.9,*;q=0.7";
        l = HeaderHelper.createAcceptedCharsetList((String)cs);
        AcceptTokenTest.assertEquals((int)3, (int)l.size());
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(0)).getToken(), (String)"windows-1251");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(1)).getToken(), (String)"utf-8");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(1)).getQvalue()), (Object)Float.valueOf(0.9f));
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(2)).getToken(), (String)"*");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(2)).getQvalue()), (Object)Float.valueOf(0.7f));
    }

    public void testListAcceptEncoding() {
        String en = null;
        List l = HeaderHelper.createAcceptedEncodingList(en);
        AcceptTokenTest.assertEquals((int)1, (int)l.size());
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(0)).getToken(), (String)"*");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        en = "";
        l = HeaderHelper.createAcceptedEncodingList((String)en);
        AcceptTokenTest.assertEquals((int)1, (int)l.size());
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(0)).getToken(), (String)"*");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        en = "compress;q=0.5, gzip;q=1.0";
        l = HeaderHelper.createAcceptedCharsetList((String)en);
        AcceptTokenTest.assertEquals((int)2, (int)l.size());
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(0)).getToken(), (String)"gzip");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        AcceptTokenTest.assertEquals((String)((AcceptToken)l.get(1)).getToken(), (String)"compress");
        AcceptTokenTest.assertEquals((Object)Float.valueOf(((AcceptToken)l.get(1)).getQvalue()), (Object)Float.valueOf(0.5f));
    }
}

