/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.ConstructorDescriptor;
import org.exoplatform.services.rest.ConstructorParameter;
import org.exoplatform.services.rest.FieldInjector;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodMap;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorMap;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodMap;
import org.exoplatform.services.rest.uri.UriPattern;

public class ResourceDescriptorTest
extends BaseTest {
    public void testFailedCreation2() {
        try {
            new AbstractResourceDescriptorImpl(Resource2.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, resource does not have public constructor");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testFailedCreation3() {
        try {
            new AbstractResourceDescriptorImpl(Resource3.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, resource has two methods that have tha same HTTP method, consumes and produces annotation");
            new AbstractResourceDescriptorImpl(Resource4.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, resource has two methods that have tha same HTTP method, consumes and produces annotation");
            new AbstractResourceDescriptorImpl(Resource5.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, resource has two methods that have tha same HTTP method, path, consumes and produces annotation");
            new AbstractResourceDescriptorImpl(Resource6.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, resource has two methods that have tha same HTTP method, path, consumes and produces annotation");
            new AbstractResourceDescriptorImpl(Resource7.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, resource has two methods that have tha same path");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testFailedCreation4() {
        try {
            new AbstractResourceDescriptorImpl(Resource8.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, method has two JAX-RS annotation on the same parameter");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        new AbstractResourceDescriptorImpl(Resource9.class);
    }

    public void testFailedCreation5() {
        try {
            new AbstractResourceDescriptorImpl(Resource10.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, constructor of per-request resource has two JAX-RS annotation on the same parameter");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        new AbstractResourceDescriptorImpl(Resource11.class);
    }

    public void testFailedCreation6() {
        try {
            new AbstractResourceDescriptorImpl(Resource12.class);
            ResourceDescriptorTest.fail((String)"Should be failed here, fields of per-request resource has two JAX-RS annotation on the same parameter");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testNotPublicMethodAnnotated() {
        new AbstractResourceDescriptorImpl(Resource14.class);
    }

    public void testCreateAbstractResourceDescriptor() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource.class);
        ResourceDescriptorTest.assertTrue((boolean)resource.isRootResource());
        ResourceDescriptorTest.assertEquals((String)"/a/{b}/", (String)resource.getPathValue().getPath());
        ResourceDescriptorTest.assertEquals(SampleResource.class, (Object)resource.getObjectClass());
        ResourceDescriptorTest.assertEquals((int)3, (int)resource.getResourceMethods().size());
        ResourceDescriptorTest.assertEquals((int)1, (int)resource.getSubResourceMethods().size());
        ResourceDescriptorTest.assertEquals((int)3, (int)((ResourceMethodMap)resource.getSubResourceMethods().values().iterator().next()).size());
        ResourceDescriptorTest.assertEquals((int)1, (int)resource.getSubResourceLocators().size());
    }

    public void testResourceMethods() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource.class);
        ResourceMethodDescriptor methodDescriptor = resource.getResourceMethods().getFirst("GET");
        ResourceDescriptorTest.assertEquals((String)"GET", (String)methodDescriptor.getHttpMethod());
        ResourceDescriptorTest.assertEquals((Object)MediaTypeHelper.DEFAULT_TYPE, methodDescriptor.consumes().get(0));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"application/xml"), methodDescriptor.produces().get(0));
        ResourceDescriptorTest.assertEquals(SampleResource.class, (Object)methodDescriptor.getParentResource().getObjectClass());
        ResourceDescriptorTest.assertEquals((int)1, (int)methodDescriptor.getMethodParameters().size());
        MethodParameter methodParameter = (MethodParameter)methodDescriptor.getMethodParameters().get(0);
        ResourceDescriptorTest.assertEquals((String)"hello", (String)methodParameter.getDefaultValue());
        ResourceDescriptorTest.assertEquals(String.class, (Object)methodParameter.getParameterClass());
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((int)2, (int)methodParameter.getAnnotations().length);
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotations()[0].annotationType());
        ResourceDescriptorTest.assertEquals(DefaultValue.class, methodParameter.getAnnotations()[1].annotationType());
        methodDescriptor = resource.getResourceMethods().getFirst("HEAD");
        ResourceDescriptorTest.assertEquals((String)"HEAD", (String)methodDescriptor.getHttpMethod());
        ResourceDescriptorTest.assertEquals((Object)MediaTypeHelper.DEFAULT_TYPE, methodDescriptor.consumes().get(0));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"application/xml"), methodDescriptor.produces().get(0));
        ResourceDescriptorTest.assertEquals(SampleResource.class, (Object)methodDescriptor.getParentResource().getObjectClass());
        ResourceDescriptorTest.assertEquals((int)1, (int)methodDescriptor.getMethodParameters().size());
        methodParameter = (MethodParameter)methodDescriptor.getMethodParameters().get(0);
        ResourceDescriptorTest.assertEquals((String)"hello", (String)methodParameter.getDefaultValue());
        ResourceDescriptorTest.assertEquals(String.class, (Object)methodParameter.getParameterClass());
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((int)2, (int)methodParameter.getAnnotations().length);
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotations()[0].annotationType());
        ResourceDescriptorTest.assertEquals(DefaultValue.class, methodParameter.getAnnotations()[1].annotationType());
    }

    public void testSubResourceMethods() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource.class);
        Collection subRes = resource.getSubResourceMethods().values();
        SubResourceMethodDescriptor subResourceMethodDescriptor = (SubResourceMethodDescriptor)((ResourceMethodMap)subRes.iterator().next()).getFirst("POST");
        ResourceDescriptorTest.assertEquals((String)"POST", (String)subResourceMethodDescriptor.getHttpMethod());
        ResourceDescriptorTest.assertEquals((String)"{c}", (String)subResourceMethodDescriptor.getPathValue().getPath());
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/plain"), subResourceMethodDescriptor.consumes().get(0));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/xml"), subResourceMethodDescriptor.consumes().get(1));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/html"), subResourceMethodDescriptor.produces().get(0));
        ResourceDescriptorTest.assertEquals(SampleResource.class, (Object)subResourceMethodDescriptor.getParentResource().getObjectClass());
        ResourceDescriptorTest.assertEquals((int)1, (int)subResourceMethodDescriptor.getMethodParameters().size());
        MethodParameter methodParameter = (MethodParameter)subResourceMethodDescriptor.getMethodParameters().get(0);
        ResourceDescriptorTest.assertEquals(null, (String)methodParameter.getDefaultValue());
        ResourceDescriptorTest.assertEquals(List.class, (Object)methodParameter.getParameterClass());
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((int)1, (int)methodParameter.getAnnotations().length);
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotations()[0].annotationType());
        subResourceMethodDescriptor = (SubResourceMethodDescriptor)((ResourceMethodMap)subRes.iterator().next()).getFirst("GET");
        ResourceDescriptorTest.assertEquals((String)"GET", (String)subResourceMethodDescriptor.getHttpMethod());
        ResourceDescriptorTest.assertEquals((String)"{d}", (String)subResourceMethodDescriptor.getPathValue().getPath());
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/plain"), subResourceMethodDescriptor.consumes().get(0));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/xml"), subResourceMethodDescriptor.consumes().get(1));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/html"), subResourceMethodDescriptor.produces().get(0));
        ResourceDescriptorTest.assertEquals(SampleResource.class, (Object)subResourceMethodDescriptor.getParentResource().getObjectClass());
        ResourceDescriptorTest.assertEquals((int)1, (int)subResourceMethodDescriptor.getMethodParameters().size());
        methodParameter = (MethodParameter)subResourceMethodDescriptor.getMethodParameters().get(0);
        ResourceDescriptorTest.assertEquals(null, (String)methodParameter.getDefaultValue());
        ResourceDescriptorTest.assertEquals(List.class, (Object)methodParameter.getParameterClass());
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((int)1, (int)methodParameter.getAnnotations().length);
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotations()[0].annotationType());
        subResourceMethodDescriptor = (SubResourceMethodDescriptor)((ResourceMethodMap)subRes.iterator().next()).getFirst("HEAD");
        ResourceDescriptorTest.assertEquals((String)"HEAD", (String)subResourceMethodDescriptor.getHttpMethod());
        ResourceDescriptorTest.assertEquals((String)"{d}", (String)subResourceMethodDescriptor.getPathValue().getPath());
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/plain"), subResourceMethodDescriptor.consumes().get(0));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/xml"), subResourceMethodDescriptor.consumes().get(1));
        ResourceDescriptorTest.assertEquals((Object)MediaType.valueOf((String)"text/html"), subResourceMethodDescriptor.produces().get(0));
        ResourceDescriptorTest.assertEquals(SampleResource.class, (Object)subResourceMethodDescriptor.getParentResource().getObjectClass());
        ResourceDescriptorTest.assertEquals((int)1, (int)subResourceMethodDescriptor.getMethodParameters().size());
        methodParameter = (MethodParameter)subResourceMethodDescriptor.getMethodParameters().get(0);
        ResourceDescriptorTest.assertEquals(null, (String)methodParameter.getDefaultValue());
        ResourceDescriptorTest.assertEquals(List.class, (Object)methodParameter.getParameterClass());
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((int)1, (int)methodParameter.getAnnotations().length);
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotations()[0].annotationType());
    }

    public void testSubResourceLocators() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource.class);
        SubResourceLocatorDescriptor subResourceLocatorDescriptor = (SubResourceLocatorDescriptor)resource.getSubResourceLocators().values().iterator().next();
        ResourceDescriptorTest.assertEquals((String)"{c}/d", (String)subResourceLocatorDescriptor.getPathValue().getPath());
        ResourceDescriptorTest.assertEquals(SampleResource.class, (Object)subResourceLocatorDescriptor.getParentResource().getObjectClass());
        ResourceDescriptorTest.assertEquals((int)1, (int)subResourceLocatorDescriptor.getMethodParameters().size());
        MethodParameter methodParameter = (MethodParameter)subResourceLocatorDescriptor.getMethodParameters().get(0);
        ResourceDescriptorTest.assertTrue((boolean)methodParameter.isEncoded());
        ResourceDescriptorTest.assertEquals(null, (String)methodParameter.getDefaultValue());
        ResourceDescriptorTest.assertEquals(String.class, (Object)methodParameter.getParameterClass());
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((int)2, (int)methodParameter.getAnnotations().length);
        ResourceDescriptorTest.assertEquals(PathParam.class, methodParameter.getAnnotations()[0].annotationType());
    }

    public void testFields() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource.class);
        List fields = resource.getFieldInjectors();
        this.cleanupSonarRuntimeData(fields);
        ResourceDescriptorTest.assertEquals((int)1, (int)fields.size());
        FieldInjector f = (FieldInjector)fields.get(0);
        ResourceDescriptorTest.assertEquals(String.class, (Object)f.getParameterClass());
        ResourceDescriptorTest.assertEquals(String.class, (Object)f.getGenericType());
        ResourceDescriptorTest.assertEquals((String)"default", (String)f.getDefaultValue());
        ResourceDescriptorTest.assertEquals(PathParam.class, f.getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((String)"b", (String)((PathParam)f.getAnnotation()).value());
        ResourceDescriptorTest.assertTrue((boolean)f.isEncoded());
    }

    public void testConstructors() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource.class);
        ResourceDescriptorTest.assertEquals((int)3, (int)resource.getConstructorDescriptors().size());
        List c = resource.getConstructorDescriptors();
        ResourceDescriptorTest.assertEquals((int)2, (int)((ConstructorDescriptor)c.get(0)).getParameters().size());
        ResourceDescriptorTest.assertEquals((int)1, (int)((ConstructorDescriptor)c.get(1)).getParameters().size());
        ResourceDescriptorTest.assertEquals((int)0, (int)((ConstructorDescriptor)c.get(2)).getParameters().size());
        ResourceDescriptorTest.assertFalse((boolean)((ConstructorParameter)((ConstructorDescriptor)c.get(0)).getParameters().get(0)).isEncoded());
        ResourceDescriptorTest.assertTrue((boolean)((ConstructorParameter)((ConstructorDescriptor)c.get(0)).getParameters().get(1)).isEncoded());
        ResourceDescriptorTest.assertEquals(QueryParam.class, ((ConstructorParameter)((ConstructorDescriptor)c.get(0)).getParameters().get(0)).getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals(PathParam.class, ((ConstructorParameter)((ConstructorDescriptor)c.get(0)).getParameters().get(1)).getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((String)"test", (String)((QueryParam)((ConstructorParameter)((ConstructorDescriptor)c.get(0)).getParameters().get(0)).getAnnotation()).value());
        ResourceDescriptorTest.assertEquals((String)"b", (String)((PathParam)((ConstructorParameter)((ConstructorDescriptor)c.get(0)).getParameters().get(1)).getAnnotation()).value());
        ResourceDescriptorTest.assertFalse((boolean)((ConstructorParameter)((ConstructorDescriptor)c.get(1)).getParameters().get(0)).isEncoded());
        ResourceDescriptorTest.assertEquals(PathParam.class, ((ConstructorParameter)((ConstructorDescriptor)c.get(1)).getParameters().get(0)).getAnnotation().annotationType());
        ResourceDescriptorTest.assertEquals((String)"b", (String)((PathParam)((ConstructorParameter)((ConstructorDescriptor)c.get(1)).getParameters().get(0)).getAnnotation()).value());
    }

    public void testResourceMethodSorting() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource1.class);
        List l = (List)resource.getResourceMethods().get((Object)"GET");
        ResourceDescriptorTest.assertEquals((String)"m4", (String)((ResourceMethodDescriptor)l.get(0)).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m3", (String)((ResourceMethodDescriptor)l.get(1)).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m2", (String)((ResourceMethodDescriptor)l.get(2)).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m5", (String)((ResourceMethodDescriptor)l.get(3)).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m0", (String)((ResourceMethodDescriptor)l.get(4)).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m1", (String)((ResourceMethodDescriptor)l.get(5)).getMethod().getName());
    }

    public void testSubResourceMethodSorting() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource2.class);
        SubResourceMethodMap srmm = resource.getSubResourceMethods();
        Set uris = srmm.keySet();
        Iterator i = uris.iterator();
        ResourceDescriptorTest.assertEquals((String)"/b/c/d", (String)((UriPattern)i.next()).getTemplate());
        ResourceDescriptorTest.assertEquals((String)"/b/c", (String)((UriPattern)i.next()).getTemplate());
        ResourceDescriptorTest.assertEquals((String)"/b/{c}", (String)((UriPattern)i.next()).getTemplate());
        ResourceDescriptorTest.assertEquals((String)"/b", (String)((UriPattern)i.next()).getTemplate());
        i = uris.iterator();
        ResourceMethodMap rmm = srmm.getMethodMap((UriPattern)i.next());
        ResourceDescriptorTest.assertEquals((int)1, (int)rmm.size());
        ResourceDescriptorTest.assertEquals((int)1, (int)((List)rmm.get((Object)"GET")).size());
        ResourceDescriptorTest.assertEquals((String)"m4", (String)((SubResourceMethodDescriptor)((List)rmm.get((Object)"GET")).get(0)).getMethod().getName());
        rmm = srmm.getMethodMap((UriPattern)i.next());
        ResourceDescriptorTest.assertEquals((int)1, (int)rmm.size());
        ResourceDescriptorTest.assertEquals((int)1, (int)((List)rmm.get((Object)"GET")).size());
        ResourceDescriptorTest.assertEquals((String)"m1", (String)((SubResourceMethodDescriptor)((List)rmm.get((Object)"GET")).get(0)).getMethod().getName());
        rmm = srmm.getMethodMap((UriPattern)i.next());
        ResourceDescriptorTest.assertEquals((int)1, (int)rmm.size());
        ResourceDescriptorTest.assertEquals((int)1, (int)((List)rmm.get((Object)"GET")).size());
        ResourceDescriptorTest.assertEquals((String)"m3", (String)((SubResourceMethodDescriptor)((List)rmm.get((Object)"GET")).get(0)).getMethod().getName());
        rmm = srmm.getMethodMap((UriPattern)i.next());
        ResourceDescriptorTest.assertEquals((int)1, (int)rmm.size());
        ResourceDescriptorTest.assertEquals((int)3, (int)((List)rmm.get((Object)"GET")).size());
        ResourceDescriptorTest.assertEquals((String)"m2", (String)((SubResourceMethodDescriptor)((List)rmm.get((Object)"GET")).get(0)).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m5", (String)((SubResourceMethodDescriptor)((List)rmm.get((Object)"GET")).get(1)).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m0", (String)((SubResourceMethodDescriptor)((List)rmm.get((Object)"GET")).get(2)).getMethod().getName());
    }

    public void testSubResourceLocatorSorting() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(SampleResource3.class);
        SubResourceLocatorMap locs = resource.getSubResourceLocators();
        Set uris = locs.keySet();
        Iterator i = uris.iterator();
        ResourceDescriptorTest.assertEquals((String)"/b/c/d", (String)((UriPattern)i.next()).getTemplate());
        ResourceDescriptorTest.assertEquals((String)"/b/c/z", (String)((UriPattern)i.next()).getTemplate());
        ResourceDescriptorTest.assertEquals((String)"/b/c", (String)((UriPattern)i.next()).getTemplate());
        ResourceDescriptorTest.assertEquals((String)"/b/{c}", (String)((UriPattern)i.next()).getTemplate());
        ResourceDescriptorTest.assertEquals((String)"/b", (String)((UriPattern)i.next()).getTemplate());
        Iterator i2 = locs.values().iterator();
        ResourceDescriptorTest.assertEquals((String)"m3", (String)((SubResourceLocatorDescriptor)i2.next()).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m1", (String)((SubResourceLocatorDescriptor)i2.next()).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m4", (String)((SubResourceLocatorDescriptor)i2.next()).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m2", (String)((SubResourceLocatorDescriptor)i2.next()).getMethod().getName());
        ResourceDescriptorTest.assertEquals((String)"m0", (String)((SubResourceLocatorDescriptor)i2.next()).getMethod().getName());
    }

    public void testInitializeFieldSuperClass() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(EndResource.class);
        List fields = resource.getFieldInjectors();
        this.cleanupSonarRuntimeData(fields);
        ResourceDescriptorTest.assertEquals((int)6, (int)fields.size());
    }

    private void cleanupSonarRuntimeData(List<FieldInjector> fields) {
        Iterator<FieldInjector> iter = fields.iterator();
        while (iter.hasNext()) {
            FieldInjector field = iter.next();
            if (!field.getName().equals("$jacocoData")) continue;
            iter.remove();
        }
    }

    @Path(value="a")
    public static class Resource2 {
        Resource2() {
        }

        @GET
        public void m1() {
        }
    }

    @Path(value="a")
    public static class Resource3 {
        @GET
        public void m1() {
        }

        @GET
        public void m2() {
        }
    }

    @Path(value="a")
    public static class Resource4 {
        @GET
        @Consumes(value={"text/xml", "application/xml", "application/xml+xhtml"})
        @Produces(value={"text/plain"})
        public void m1() {
        }

        @GET
        @Consumes(value={"application/xml", "text/xml", "application/xml+xhtml"})
        @Produces(value={"text/plain"})
        public void m2() {
        }
    }

    @Path(value="a")
    public static class Resource5 {
        @GET
        @Path(value="b")
        public void m1() {
        }

        @GET
        @Path(value="b")
        public void m2() {
        }
    }

    @Path(value="a")
    public static class Resource6 {
        @GET
        @Consumes(value={"text/xml", "application/xml", "application/xml+xhtml"})
        @Produces(value={"text/plain"})
        @Path(value="b")
        public void m1() {
        }

        @GET
        @Consumes(value={"application/xml", "text/xml", "application/xml+xhtml"})
        @Produces(value={"text/plain"})
        @Path(value="b")
        public void m2() {
        }
    }

    @Path(value="/a")
    public static class Resource7 {
        @Path(value="b")
        public Object m1() {
            return new Object();
        }

        @Path(value="/b")
        public Object m2() {
            return new Object();
        }
    }

    @Path(value="/a")
    public static class Resource8 {
        @GET
        @Path(value="b")
        public void m1(@PathParam(value="b") @HeaderParam(value="head1") String b) {
        }
    }

    @Path(value="/a")
    public static class Resource9 {
        @GET
        @Path(value="c")
        public void m1(@Test @HeaderParam(value="head1") String b) {
        }
    }

    @Path(value="/a")
    public static class Resource10 {
        public Resource10(@PathParam(value="b") @HeaderParam(value="head1") String b) {
        }

        @GET
        public void m1() {
        }
    }

    @Path(value="/a")
    public static class Resource11 {
        public Resource11(@PathParam(value="b") String b, @QueryParam(value="c") int c) {
        }

        public Resource11(@HeaderParam(value="head1") int b, @PathParam(value="c") String c) {
        }

        @GET
        public void m1() {
        }
    }

    public static class Resource12 {
        @Context
        private UriInfo uriInfo;
        @PathParam(value="b")
        @QueryParam(value="query")
        String b;

        @GET
        public void m1() {
        }
    }

    @Path(value="/")
    public static class Resource14 {
        @GET
        void get() {
        }

        @POST
        public void post() {
        }
    }

    @Path(value="/a/{b}/")
    public static class SampleResource {
        @DefaultValue(value="default")
        @PathParam(value="b")
        @Encoded
        private String field1;

        public SampleResource(@PathParam(value="b") String str) {
        }

        public SampleResource() {
        }

        public SampleResource(@QueryParam(value="test") int i, @Encoded @PathParam(value="b") String str) {
        }

        @POST
        @Path(value="{c}")
        @Consumes(value={"text/plain", "text/xml"})
        @Produces(value={"text/html"})
        public void post1(@PathParam(value="b") List<String> p) {
        }

        @GET
        @Path(value="{d}")
        @Consumes(value={"text/plain", "text/xml"})
        @Produces(value={"text/html"})
        public void get1(@PathParam(value="b") List<String> p) {
        }

        @Path(value="{c}/d")
        public void get2(@PathParam(value="b") @Encoded String p) {
        }

        @GET
        @Produces(value={"application/xml"})
        public void get3(@PathParam(value="b") @DefaultValue(value="hello") String p) {
        }
    }

    @Path(value="a")
    public static class SampleResource1 {
        @Consumes(value={"application/*", "application/xml", "text/*"})
        @Produces(value={"text/plain", "text/html", "text/*"})
        @GET
        public void m0() {
        }

        @GET
        public void m1() {
        }

        @Consumes(value={"application/*", "text/*"})
        @Produces(value={"text/plain", "text/html"})
        @GET
        public void m2() {
        }

        @Consumes(value={"application/xml", "text/plain"})
        @GET
        public void m3() {
        }

        @Consumes(value={"application/xml"})
        @GET
        public void m4() {
        }

        @Consumes(value={"text/*"})
        @Produces(value={"text/html", "text/*"})
        @GET
        public void m5() {
        }
    }

    @Path(value="a")
    public static class SampleResource2 {
        @Consumes(value={"application/*", "application/xml", "text/*"})
        @Produces(value={"text/plain", "text/html", "text/*"})
        @GET
        @Path(value="b")
        public void m0() {
        }

        @GET
        @Path(value="b/c")
        public void m1() {
        }

        @Consumes(value={"application/*", "text/*"})
        @Produces(value={"text/plain", "text/html"})
        @GET
        @Path(value="b")
        public void m2() {
        }

        @Consumes(value={"application/xml", "text/plain"})
        @GET
        @Path(value="b/{c}")
        public void m3() {
        }

        @Consumes(value={"application/xml"})
        @GET
        @Path(value="b/c/d")
        public void m4() {
        }

        @Consumes(value={"text/*"})
        @Produces(value={"text/html", "text/*"})
        @GET
        @Path(value="b")
        public void m5() {
        }
    }

    @Path(value="a")
    public static class SampleResource3 {
        @Path(value="b")
        public void m0() {
        }

        @Path(value="b/c/z")
        public void m1() {
        }

        @Path(value="b/{c}")
        public void m2() {
        }

        @Path(value="b/c/d")
        public void m3() {
        }

        @Path(value="b/c")
        public void m4() {
        }
    }

    public static class EndResource
    extends ExtResource {
        @Context
        private HttpHeaders header;
        @Context
        private UriInfo something;

        @GET
        public void m1() {
        }
    }

    public static abstract class ExtResource
    extends AbstractResource {
        @Context
        protected SecurityContext sc;
    }

    public static abstract class AbstractResource {
        @Context
        protected UriInfo uriInfo;
        @Context
        public Request request;
        @Context
        protected UriInfo something;
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Test {
    }

    @Path(value="a")
    public static class Resource1 {
        public void m1() {
        }
    }
}

