/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.exoplatform.services.rest.BaseTest;

public class ContextResolverTest
extends BaseTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.providers.addContextResolver(ContextResolver1.class);
        this.providers.addContextResolver(ContextResolver2.class);
        this.providers.addContextResolver(ContextResolver3.class);
        this.providers.addContextResolver(ContextResolver4.class);
        this.providers.addContextResolver(ContextResolver5.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.setUp();
    }

    public void testContextResolver() {
        ContextResolverTest.assertEquals((String)"text", (String)((String)this.providers.getContextResolver(String.class, new MediaType("text", "plain")).getContext(String.class)));
        ContextResolverTest.assertEquals((String)"*", (String)((String)this.providers.getContextResolver(String.class, new MediaType("xxx", "xxx")).getContext(String.class)));
        ContextResolverTest.assertEquals((String)"xml", (String)((String)this.providers.getContextResolver(String.class, new MediaType("text", "xml")).getContext(String.class)));
        ContextResolverTest.assertEquals((String)"html", (String)((String)this.providers.getContextResolver(String.class, new MediaType("text", "html")).getContext(String.class)));
        ContextResolverTest.assertEquals((String)"anytext", (String)((String)this.providers.getContextResolver(String.class, new MediaType("text", "xxx")).getContext(String.class)));
    }

    @Provider
    @Produces(value={"text/plain"})
    public static class ContextResolver1
    implements ContextResolver<String> {
        public String getContext(Class<?> type) {
            return "text";
        }
    }

    @Provider
    public static class ContextResolver2
    implements ContextResolver<String> {
        public String getContext(Class<?> type) {
            return "*";
        }
    }

    @Provider
    @Produces(value={"text/xml"})
    public static class ContextResolver3
    implements ContextResolver<String> {
        public String getContext(Class<?> type) {
            return "xml";
        }
    }

    @Provider
    @Produces(value={"text/html"})
    public static class ContextResolver4
    implements ContextResolver<String> {
        public String getContext(Class<?> type) {
            return "html";
        }
    }

    @Provider
    @Produces(value={"text/*"})
    public static class ContextResolver5
    implements ContextResolver<String> {
        public String getContext(Class<?> type) {
            return "anytext";
        }
    }
}

