/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;

public class FileEntityProviderTest
extends BaseTest {
    public void testRead() throws Exception {
        MessageBodyReader reader = this.providers.getMessageBodyReader(File.class, null, null, MediaTypeHelper.DEFAULT_TYPE);
        FileEntityProviderTest.assertNotNull((Object)reader);
        FileEntityProviderTest.assertNotNull((Object)this.providers.getMessageBodyReader(File.class, null, null, null));
        FileEntityProviderTest.assertTrue((boolean)reader.isReadable(File.class, null, null, null));
        String data = "to be or not to be";
        File result = (File)reader.readFrom(File.class, null, null, null, null, (InputStream)new ByteArrayInputStream(data.getBytes("UTF-8")));
        FileEntityProviderTest.assertTrue((boolean)result.exists());
        FileEntityProviderTest.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        FileInputStream fdata = new FileInputStream(result);
        InputStreamReader freader = new InputStreamReader((InputStream)fdata, "UTF-8");
        char[] c = new char[1024];
        int b = freader.read(c);
        String resstr = new String(c, 0, b);
        FileEntityProviderTest.assertEquals((String)data, (String)resstr);
        result.delete();
    }

    public void testWrite() throws Exception {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(File.class, null, null, MediaTypeHelper.DEFAULT_TYPE);
        FileEntityProviderTest.assertNotNull((Object)writer);
        FileEntityProviderTest.assertNotNull((Object)this.providers.getMessageBodyWriter(File.class, null, null, null));
        FileEntityProviderTest.assertTrue((boolean)writer.isWriteable(File.class, null, null, null));
        byte[] data = "to be or not to be".getBytes("UTF-8");
        File source = File.createTempFile("fileentitytest", null);
        FileOutputStream fout = new FileOutputStream(source);
        fout.write(data);
        fout.close();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.writeTo((Object)source, File.class, null, null, null, null, (OutputStream)out);
        FileEntityProviderTest.assertTrue((boolean)Arrays.equals(data, out.toByteArray()));
        source.delete();
    }
}

