/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorValidator;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodMap;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;

public class ResourceDescriptorValidatorTest
extends BaseTest {
    public void testAbstractResourceDescriptorValidator() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(Resource2.class);
        try {
            resource.accept((ResourceDescriptorVisitor)new ResourceDescriptorValidator());
            ResourceDescriptorValidatorTest.fail((String)"Exception should be here");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testResourceMethodDescriptorValidator() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(Resource3.class);
        for (List l : resource.getResourceMethods().values()) {
            ResourceDescriptorValidator validator = new ResourceDescriptorValidator();
            for (ResourceMethodDescriptor rmd : l) {
                Method m = rmd.getMethod();
                if (m == null) continue;
                String mn = rmd.getMethod().getName();
                if ("m1".equals(mn)) {
                    rmd.accept((ResourceDescriptorVisitor)validator);
                    continue;
                }
                try {
                    rmd.accept((ResourceDescriptorVisitor)validator);
                    ResourceDescriptorValidatorTest.fail((String)"Exception should be here");
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    public void testSubResourceMethodDescriptorValidator() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(Resource4.class);
        ResourceDescriptorValidator validator = new ResourceDescriptorValidator();
        for (ResourceMethodMap srmm : resource.getSubResourceMethods().values()) {
            for (List l : srmm.values()) {
                for (SubResourceMethodDescriptor srmd : l) {
                    String mn = srmd.getMethod().getName();
                    if ("m1".equals(mn) || "m3".equals(mn)) {
                        srmd.accept((ResourceDescriptorVisitor)validator);
                        continue;
                    }
                    try {
                        srmd.accept((ResourceDescriptorVisitor)validator);
                        ResourceDescriptorValidatorTest.fail((String)"Exception should be here");
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
        }
    }

    public void testSubResourceLocatorDescriptorValidator() {
        AbstractResourceDescriptorImpl resource = new AbstractResourceDescriptorImpl(Resource5.class);
        ResourceDescriptorValidator validator = new ResourceDescriptorValidator();
        for (SubResourceLocatorDescriptor rmd : resource.getSubResourceLocators().values()) {
            String mn = rmd.getMethod().getName();
            if ("m1".equals(mn)) {
                rmd.accept((ResourceDescriptorVisitor)validator);
                continue;
            }
            try {
                rmd.accept((ResourceDescriptorVisitor)validator);
                ResourceDescriptorValidatorTest.fail((String)"Exception should be here");
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    @Path(value="")
    public static class Resource2 {
        @GET
        public void m1() {
        }
    }

    @Path(value="/a/b")
    public static class Resource3 {
        @GET
        public void m1(@FormParam(value="a") String t, MultivaluedMap<String, String> entity) {
        }

        @POST
        public void m2(@FormParam(value="a") String t, MultivaluedMap entity) {
        }

        @PUT
        public void m3(@FormParam(value="a") String t, String entity) {
        }

        @HEAD
        public void m4(String entity1, String entity2) {
        }
    }

    @Path(value="/a/b")
    public static class Resource4 {
        @GET
        @Path(value="c")
        public void m1() {
        }

        @GET
        @Path(value="")
        public void m2() {
        }

        @GET
        @Path(value="c/d")
        public void m3(@FormParam(value="a") String t, MultivaluedMap<String, String> entity) {
        }

        @POST
        @Path(value="c/d/e")
        public void m4(@FormParam(value="a") String t, MultivaluedMap entity) {
        }

        @PUT
        @Path(value="c/d/e/f")
        public void m5(@FormParam(value="a") String t, String entity) {
        }

        @GET
        @Path(value="c/d/e/f/g")
        public void m6(String entity1, String entity2) {
        }
    }

    @Path(value="/a/b")
    public static class Resource5 {
        @Path(value="c")
        public void m1() {
        }

        @Path(value="")
        public void m2() {
        }

        @Path(value="c/d")
        public void m3(@PathParam(value="a") String t, String entity) {
        }
    }
}

