/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import jakarta.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.GenericMethodResource;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;
import org.exoplatform.services.test.mock.MockHttpServletRequest;

public class MethodInvokerFilterTest
extends BaseTest {
    public void testInvokerFilter() throws Exception {
        Resource1 r = new Resource1();
        this.registry(r);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("/a/b", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        MethodInvokerFilterTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a/b", "", null, null, envctx).getStatus());
        httpRequest = new MockHttpServletRequest("/a", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        MethodInvokerFilterTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a", "", null, null, envctx).getStatus());
        this.providers.addMethodInvokerFilter(MethodInvokerFilter1.class);
        httpRequest = new MockHttpServletRequest("/a/b", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        MethodInvokerFilterTest.assertEquals((int)400, (int)this.launcher.service("GET", "/a/b", "", null, null, envctx).getStatus());
        httpRequest = new MockHttpServletRequest("/a", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        MethodInvokerFilterTest.assertEquals((int)204, (int)this.launcher.service("GET", "/a", "", null, null, envctx).getStatus());
        this.unregistry(r);
    }

    public void testInvokerFilter2() throws Exception {
        Resource2 r = new Resource2();
        this.registry(r);
        MethodInvokerFilterTest.assertEquals((int)204, (int)this.launcher.service("GET", "/b/c", "", null, null, null).getStatus());
        MethodInvokerFilterTest.assertEquals((int)204, (int)this.launcher.service("GET", "/b/d", "", null, null, null).getStatus());
        this.providers.addMethodInvokerFilter((MethodInvokerFilter)new MethodInvokerFilter2());
        MethodInvokerFilterTest.assertEquals((int)400, (int)this.launcher.service("GET", "/b/c", "", null, null, null).getStatus());
        MethodInvokerFilterTest.assertEquals((int)204, (int)this.launcher.service("GET", "/b/d", "", null, null, null).getStatus());
        this.unregistry(r);
    }

    @Path(value="a")
    public static class Resource1 {
        @GET
        public void m0() {
        }

        @GET
        @Path(value="b")
        public void m1() {
        }
    }

    @Filter
    public static class MethodInvokerFilter1
    implements MethodInvokerFilter {
        private UriInfo uriInfo;
        private HttpHeaders httpHeaders;
        @Context
        private Providers providers;
        @Context
        private HttpServletRequest httpRequest;
        private ResourceBinder binder;

        public MethodInvokerFilter1(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, ResourceBinder binder) {
            this.uriInfo = uriInfo;
            this.httpHeaders = httpHeaders;
            this.binder = binder;
        }

        public void accept(GenericMethodResource genericMethodResource) {
            if (this.uriInfo != null && this.httpHeaders != null && this.providers != null && this.httpRequest != null && this.binder != null) {
                if (genericMethodResource instanceof SubResourceMethodDescriptor) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
                }
            } else {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            }
        }
    }

    @Path(value="b")
    public static class Resource2 {
        @GET
        @Path(value="c")
        public void m0() {
        }

        @GET
        @Path(value="d")
        public void m1() {
        }
    }

    @Filter
    @Path(value="b/c")
    public static class MethodInvokerFilter2
    implements MethodInvokerFilter {
        public void accept(GenericMethodResource genericMethodResource) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
    }
}

