/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.filter;

import java.net.URI;
import javax.ws.rs.ext.RuntimeDelegate;
import junit.framework.TestCase;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.ext.filter.UriNormalizationFilter;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;

public class UriNormalizationFilterTest
extends TestCase {
    private String[] testUris = new String[]{"http://localhost:8080/servlet/../1//2/3/./../../4", "http://localhost:8080/servlet/./1//2/3/./../../4", "http://localhost:8080/servlet/1//2/3/./../../4", "http://localhost:8080/servlet/1//2./3/./../4", "http://localhost:8080/servlet/1//.2/3/./../4", "http://localhost:8080/servlet/1..//.2/3/./../4", "http://localhost:8080/servlet/./1//2/3/./../../4", "http://localhost:8080/servlet/.", "http://localhost:8080/servlet/..", "http://localhost:8080/servlet/1"};
    private String[] normalizedUris = new String[]{"http://localhost:8080/1/4", "http://localhost:8080/servlet/1/4", "http://localhost:8080/servlet/1/4", "http://localhost:8080/servlet/1/2./4", "http://localhost:8080/servlet/1/.2/4", "http://localhost:8080/servlet/1../.2/4", "http://localhost:8080/servlet/1/4", "http://localhost:8080/servlet/", "http://localhost:8080/", "http://localhost:8080/servlet/1"};

    public void setUp() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
    }

    public void testURIFilter() throws Exception {
        URI baseUri = new URI("http://localhost:8080/servlet/");
        UriNormalizationFilter filter = new UriNormalizationFilter();
        for (int i = 0; i < this.testUris.length; ++i) {
            URI requestUri = new URI(this.testUris[i]);
            ContainerRequest request = new ContainerRequest("", requestUri, baseUri, null, null);
            filter.doFilter((GenericContainerRequest)request);
            UriNormalizationFilterTest.assertEquals((String)this.normalizedUris[i], (String)request.getRequestUri().toString());
        }
    }
}

