/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.test.mock;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class MockHttpSession
implements HttpSession {
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean isValid = true;

    public long getCreationTime() {
        return 0L;
    }

    public String getId() {
        return "MockSessionId";
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public void setMaxInactiveInterval(int i) {
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public Object getAttribute(String s) {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getAttribute() on invalidated session");
        }
        return this.attributes.get(s);
    }

    public Object getValue(String s) {
        return this.getAttribute(s);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getAttribute() on invalidated session");
        }
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call getAttribute() on invalidated session");
        }
        String[] results = new String[]{};
        return this.attributes.keySet().toArray(results);
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void putValue(String s, Object o) {
        this.setAttribute(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public void removeValue(String s) {
        this.removeAttribute(s);
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot call invalidate() on invalidated session");
        }
        this.isValid = false;
    }

    public boolean isNew() {
        return false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }
}

