/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.jakarta9.instrument.jms.MessageConsumerInvocationHandler;
import io.micrometer.jakarta9.instrument.jms.MessageProducerInvocationHandler;
import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class SessionInvocationHandler
implements InvocationHandler {
    private final Session target;
    private final ObservationRegistry registry;

    SessionInvocationHandler(Session session, ObservationRegistry registry) {
        this.target = session;
        this.registry = registry;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object result = method.invoke((Object)this.target, args);
            if (result instanceof MessageProducer) {
                MessageProducer producer = (MessageProducer)result;
                MessageProducerInvocationHandler producerHandler = new MessageProducerInvocationHandler(producer, this.registry);
                return Proxy.newProxyInstance(this.target.getClass().getClassLoader(), new Class[]{MessageProducer.class}, (InvocationHandler)producerHandler);
            }
            if (result instanceof MessageConsumer) {
                MessageConsumer consumer = (MessageConsumer)result;
                MessageConsumerInvocationHandler consumerHandler = new MessageConsumerInvocationHandler(consumer, this.registry);
                return Proxy.newProxyInstance(this.target.getClass().getClassLoader(), new Class[]{MessageConsumer.class}, (InvocationHandler)consumerHandler);
            }
            return result;
        }
        catch (InvocationTargetException exc) {
            throw exc.getTargetException();
        }
    }
}

