/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.atlas;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public class SpectatorLongTaskTimer
extends DefaultLongTaskTimer
implements LongTaskTimer {
    private final com.netflix.spectator.api.LongTaskTimer timer;

    SpectatorLongTaskTimer(Meter.Id id, com.netflix.spectator.api.LongTaskTimer timer, Clock clock, DistributionStatisticConfig distributionStatisticConfig) {
        super(id, clock, TimeUnit.NANOSECONDS, distributionStatisticConfig, true);
        this.timer = timer;
    }

    public LongTaskTimer.Sample start() {
        return new SpectatorSample(super.start(), this.timer.start());
    }

    public double duration(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.timer.duration(), (TimeUnit)unit);
    }

    public int activeTasks() {
        return this.timer.activeTasks();
    }

    class SpectatorSample
    extends LongTaskTimer.Sample {
        private final LongTaskTimer.Sample delegate;
        private final long taskId;

        public SpectatorSample(LongTaskTimer.Sample delegate, long taskId) {
            this.delegate = delegate;
            this.taskId = taskId;
        }

        public long stop() {
            this.delegate.stop();
            return SpectatorLongTaskTimer.this.timer.stop(this.taskId);
        }

        public double duration(TimeUnit unit) {
            return TimeUtils.nanosToUnit((double)SpectatorLongTaskTimer.this.timer.duration(this.taskId), (TimeUnit)unit);
        }
    }
}

