/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.types;

import io.micrometer.dynatrace.types.DynatraceSummarySnapshot;

final class DynatraceSummary {
    private long count;
    private double total;
    private double min;
    private double max;

    DynatraceSummary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordNonNegative(double amount) {
        if (amount < 0.0) {
            return;
        }
        DynatraceSummary dynatraceSummary = this;
        synchronized (dynatraceSummary) {
            this.max = Math.max(this.max, amount);
            this.min = this.count > 0L ? Math.min(this.min, amount) : amount;
            this.total += amount;
            ++this.count;
        }
    }

    long getCount() {
        return this.count;
    }

    double getTotal() {
        return this.total;
    }

    double getMin() {
        return this.min;
    }

    double getMax() {
        return this.max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DynatraceSummarySnapshot takeSummarySnapshot() {
        DynatraceSummary dynatraceSummary = this;
        synchronized (dynatraceSummary) {
            return new DynatraceSummarySnapshot(this.min, this.max, this.total, this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DynatraceSummarySnapshot takeSummarySnapshotAndReset() {
        DynatraceSummary dynatraceSummary = this;
        synchronized (dynatraceSummary) {
            DynatraceSummarySnapshot snapshot = this.takeSummarySnapshot();
            this.reset();
            return snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        DynatraceSummary dynatraceSummary = this;
        synchronized (dynatraceSummary) {
            this.min = 0.0;
            this.max = 0.0;
            this.total = 0.0;
            this.count = 0L;
        }
    }
}

