/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.semconv.NetworkAttributes;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class OtelSpan
implements Span {
    static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey((String)"peer.service");
    final io.opentelemetry.api.trace.Span delegate;
    final OtelTraceContext otelTraceContext;

    public OtelSpan(io.opentelemetry.api.trace.Span delegate) {
        this.delegate = delegate;
        this.otelTraceContext = new OtelTraceContext(delegate.getSpanContext(), delegate);
    }

    public OtelSpan(io.opentelemetry.api.trace.Span delegate, Context context) {
        this.delegate = delegate;
        this.otelTraceContext = new OtelTraceContext(context, delegate.getSpanContext(), delegate);
    }

    public OtelSpan(OtelTraceContext traceContext) {
        this.delegate = traceContext.span != null ? traceContext.span : io.opentelemetry.api.trace.Span.current();
        this.otelTraceContext = traceContext;
    }

    public static io.opentelemetry.api.trace.Span toOtel(Span span) {
        return ((OtelSpan)span).delegate;
    }

    public static Span fromOtel(io.opentelemetry.api.trace.Span span) {
        return new OtelSpan(span);
    }

    public static Span fromOtel(io.opentelemetry.api.trace.Span span, Context context) {
        return new OtelSpan(span, context);
    }

    public boolean isNoop() {
        return !this.delegate.isRecording();
    }

    public OtelTraceContext context() {
        if (this.delegate == null) {
            return null;
        }
        return this.otelTraceContext;
    }

    public Span start() {
        return this;
    }

    public Span name(String name) {
        this.delegate.updateName(name);
        return this;
    }

    public Span event(String value) {
        this.delegate.addEvent(value);
        return this;
    }

    public Span event(String value, long time, TimeUnit timeUnit) {
        this.delegate.addEvent(value, time, timeUnit);
        return this;
    }

    public Span tag(String key, String value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span tag(String key, long value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span tag(String key, double value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span tag(String key, boolean value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span tagOfStrings(String key, List<String> values) {
        this.delegate.setAttribute(AttributeKey.stringArrayKey((String)key), values);
        return this;
    }

    public Span tagOfLongs(String key, List<Long> values) {
        this.delegate.setAttribute(AttributeKey.longArrayKey((String)key), values);
        return this;
    }

    public Span tagOfDoubles(String key, List<Double> values) {
        this.delegate.setAttribute(AttributeKey.doubleArrayKey((String)key), values);
        return this;
    }

    public Span tagOfBooleans(String key, List<Boolean> values) {
        this.delegate.setAttribute(AttributeKey.booleanArrayKey((String)key), values);
        return this;
    }

    public void end(long time, TimeUnit timeUnit) {
        if (this.isStatusUnset()) {
            this.delegate.setStatus(StatusCode.OK);
        }
        this.delegate.end(time, timeUnit);
    }

    public Span remoteIpAndPort(String ip, int port) {
        this.delegate.setAttribute(NetworkAttributes.NETWORK_PEER_ADDRESS, (Object)ip);
        this.delegate.setAttribute(NetworkAttributes.NETWORK_PEER_PORT, port);
        return this;
    }

    public Span error(Throwable throwable) {
        this.delegate.recordException(throwable);
        this.delegate.setStatus(StatusCode.ERROR, throwable.getMessage());
        return this;
    }

    public void end() {
        if (this.isStatusUnset()) {
            this.delegate.setStatus(StatusCode.OK);
        }
        this.delegate.end();
    }

    public void abandon() {
    }

    public Span remoteServiceName(String remoteServiceName) {
        this.delegate.setAttribute(PEER_SERVICE, (Object)remoteServiceName);
        return this;
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtelSpan otelSpan = (OtelSpan)o;
        io.opentelemetry.api.trace.Span span = otelSpan.delegate;
        if (span instanceof SpanFromSpanContext) {
            span = ((SpanFromSpanContext)span).span;
        }
        return Objects.equals(this.delegate, span);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    private boolean isStatusUnset() {
        if (this.delegate instanceof ReadableSpan) {
            return ((ReadableSpan)this.delegate).toSpanData().getStatus().getStatusCode() == StatusCode.UNSET;
        }
        return false;
    }
}

