/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.annotation;

import io.micrometer.tracing.annotation.ContinueSpan;
import io.micrometer.tracing.annotation.MethodInvocationProcessor;
import io.micrometer.tracing.annotation.NewSpan;
import io.micrometer.tracing.annotation.SpanAspectMethodInvocation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jspecify.annotations.Nullable;

@Aspect
public class SpanAspect {
    private final MethodInvocationProcessor methodInvocationProcessor;

    public SpanAspect(MethodInvocationProcessor methodInvocationProcessor) {
        this.methodInvocationProcessor = methodInvocationProcessor;
    }

    @Around(value="@annotation(io.micrometer.tracing.annotation.ContinueSpan)")
    public @Nullable Object continueSpanMethod(ProceedingJoinPoint pjp) throws Throwable {
        Method method = this.getMethod(pjp);
        ContinueSpan continueSpan = method.getAnnotation(ContinueSpan.class);
        return this.methodInvocationProcessor.process(new SpanAspectMethodInvocation(pjp, method), null, continueSpan);
    }

    @Around(value="@annotation(io.micrometer.tracing.annotation.NewSpan)")
    public @Nullable Object newSpanMethod(ProceedingJoinPoint pjp) throws Throwable {
        Method method = this.getMethod(pjp);
        NewSpan newSpan = method.getAnnotation(NewSpan.class);
        return this.methodInvocationProcessor.process(new SpanAspectMethodInvocation(pjp, method), newSpan, null);
    }

    private Method getMethod(ProceedingJoinPoint pjp) throws NoSuchMethodException {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return pjp.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
    }
}

