/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cbeffutil.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;

public class CbeffImageConverterTest {
    public static void main(String[] args) throws Exception {
        byte[] fileContent = CbeffImageConverterTest.getImageAsBytes();
        FileOutputStream fos = new FileOutputStream(new File("C:\\Users\\M1049825\\Documents\\Biometric-Data-Samples\\Biometric-Data-Samples\\ISOImage", "LeftIndexFingerImage.iso"));
        int dataLength = fileContent.length;
        long headerLength = 32L;
        long recordLength = headerLength + (long)dataLength;
        DataOutputStream dataOut = new DataOutputStream(fos);
        dataOut.writeInt(1179210240);
        dataOut.writeInt(0x30313000);
        CbeffImageConverterTest.writeLong(recordLength, dataOut, 6);
        dataOut.writeShort(0);
        dataOut.writeShort(31);
        dataOut.writeByte(1);
        dataOut.writeByte(1);
        dataOut.writeShort(500);
        dataOut.writeShort(500);
        dataOut.writeShort(500);
        dataOut.writeShort(500);
        dataOut.writeByte(8);
        dataOut.writeByte(2);
        dataOut.writeShort(1);
        CbeffImageConverterTest.writeObject(dataOut);
        System.out.println(recordLength);
    }

    private static byte[] getImageAsBytes() throws Exception {
        return Files.readAllBytes(Paths.get("C:\\Users\\M1049825\\Documents\\Biometric-Data-Samples\\Biometric-Data-Samples\\Sample-1\\Finger\\LeftIndexFingerImage.bmp", new String[0]));
    }

    private static void writeLong(long value, OutputStream out, int byteCount) throws IOException {
        int i;
        if (byteCount <= 0) {
            return;
        }
        for (i = 0; i < byteCount - 8; ++i) {
            out.write(0);
        }
        if (byteCount > 8) {
            byteCount = 8;
        }
        for (i = byteCount - 1; i >= 0; --i) {
            long mask = 255L << i * 8;
            byte b = (byte)((value & mask) >> i * 8);
            out.write(b);
        }
    }

    protected static void writeObject(OutputStream out) throws Exception {
        ByteArrayOutputStream imageOut = new ByteArrayOutputStream();
        CbeffImageConverterTest.writeImage(imageOut);
        imageOut.flush();
        byte[] imageBytes = imageOut.toByteArray();
        imageOut.close();
        long fingerDataBlockLength = imageBytes.length + 14;
        DataOutputStream dataOut = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        dataOut.writeInt((int)(fingerDataBlockLength & 0xFFFFFFFFL));
        dataOut.writeByte(2);
        dataOut.writeByte(1);
        dataOut.writeByte(1);
        dataOut.writeByte(69);
        dataOut.writeByte(0);
        dataOut.writeShort(275);
        dataOut.writeShort(400);
        dataOut.writeByte(1);
        dataOut.write(imageBytes);
        dataOut.flush();
    }

    protected static void writeImage(OutputStream outputStream) throws Exception {
        outputStream.write(CbeffImageConverterTest.getImageAsBytes());
    }
}

