/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.KeyValueOperation;
import io.nats.client.api.MessageInfo;
import io.nats.client.impl.Headers;
import io.nats.client.support.NatsKeyValueUtil;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Arrays;

public class KeyValueEntry
extends ApiResponse<KeyValueEntry> {
    private final NatsKeyValueUtil.BucketAndKey bucketAndKey;
    private final byte[] value;
    private final long dataLen;
    private final ZonedDateTime created;
    private final long revision;
    private final long delta;
    private final KeyValueOperation op;

    public KeyValueEntry(MessageInfo mi) {
        Headers h = mi.getHeaders();
        this.bucketAndKey = new NatsKeyValueUtil.BucketAndKey(mi.getSubject());
        this.value = KeyValueEntry.extractValue(mi.getData());
        this.dataLen = KeyValueEntry.calculateLength(this.value, h);
        this.created = mi.getTime();
        this.revision = mi.getSeq();
        this.delta = 0L;
        this.op = NatsKeyValueUtil.getOperation(h);
    }

    public KeyValueEntry(Message m) {
        Headers h = m.getHeaders();
        this.bucketAndKey = new NatsKeyValueUtil.BucketAndKey(m.getSubject());
        this.value = KeyValueEntry.extractValue(m.getData());
        this.dataLen = KeyValueEntry.calculateLength(this.value, h);
        this.created = m.metaData().timestamp();
        this.revision = m.metaData().streamSequence();
        this.delta = m.metaData().pendingCount();
        this.op = NatsKeyValueUtil.getOperation(h);
    }

    public String getBucket() {
        return this.bucketAndKey.bucket;
    }

    public String getKey() {
        return this.bucketAndKey.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.value == null ? null : new String(this.value, StandardCharsets.UTF_8);
    }

    public Long getValueAsLong() {
        String svalue = this.value == null ? null : new String(this.value, StandardCharsets.US_ASCII);
        return svalue == null ? null : Long.valueOf(Long.parseLong(svalue));
    }

    public long getDataLen() {
        return this.dataLen;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getDelta() {
        return this.delta;
    }

    public KeyValueOperation getOperation() {
        return this.op;
    }

    public String toString() {
        return "KvEntry{bucket='" + this.bucketAndKey.bucket + '\'' + ", key='" + this.bucketAndKey.key + '\'' + ", operation=" + (Object)((Object)this.op) + ", revision=" + this.revision + ", delta=" + this.delta + ", dataLen=" + this.dataLen + ", created=" + this.created + '}';
    }

    private static byte[] extractValue(byte[] data) {
        return data == null || data.length == 0 ? null : data;
    }

    private static long calculateLength(byte[] value, Headers h) {
        if (value == null) {
            String hlen = h == null ? null : h.getFirst("Nats-Msg-Size");
            return hlen == null ? 0L : Long.parseLong(hlen);
        }
        return value.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueEntry that = (KeyValueEntry)o;
        if (this.dataLen != that.dataLen) {
            return false;
        }
        if (this.revision != that.revision) {
            return false;
        }
        if (this.delta != that.delta) {
            return false;
        }
        if (!this.bucketAndKey.equals(that.bucketAndKey)) {
            return false;
        }
        if (!Arrays.equals(this.value, that.value)) {
            return false;
        }
        if (!this.created.equals(that.created)) {
            return false;
        }
        return this.op == that.op;
    }

    public int hashCode() {
        int result = this.bucketAndKey.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        result = 31 * result + (int)(this.dataLen ^ this.dataLen >>> 32);
        result = 31 * result + this.created.hashCode();
        result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
        result = 31 * result + (int)(this.delta ^ this.delta >>> 32);
        result = 31 * result + this.op.hashCode();
        return result;
    }
}

