/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NatsJetStreamPullSubscription
extends NatsJetStreamSubscription {
    NatsJetStreamPullSubscription(String sid, String subject, NatsConnection connection, NatsJetStream js, String stream, String consumer, MessageManager statusManager) {
        super(sid, subject, null, connection, null, js, stream, consumer, statusManager);
    }

    @Override
    boolean isPullMode() {
        return true;
    }

    @Override
    public void pull(int batchSize) {
        this._pull(batchSize, false, null);
    }

    @Override
    public void pullNoWait(int batchSize) {
        this._pull(batchSize, true, null);
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        this.durationGtZeroRequired(expiresIn, "Expires In");
        this._pull(batchSize, false, expiresIn);
    }

    @Override
    public void pullExpiresIn(int batchSize, long expiresInMillis) {
        this.pullExpiresIn(batchSize, Duration.ofMillis(expiresInMillis));
    }

    @Override
    public List<Message> fetch(int batchSize, long maxWaitMillis) {
        return this.fetch(batchSize, Duration.ofMillis(maxWaitMillis));
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        this.durationGtZeroRequired(maxWait, "Fetch max");
        ArrayList<Message> messages = new ArrayList<Message>(batchSize);
        try {
            long expiresIn;
            this.pullNoWait(batchSize);
            long endTime = System.currentTimeMillis() + maxWait.toMillis();
            this.read(messages, batchSize, endTime);
            if (messages.size() == 0 && (expiresIn = endTime - System.currentTimeMillis() - 10L) > 0L) {
                this.pullExpiresIn(batchSize, expiresIn);
                this.read(messages, batchSize, endTime);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return messages;
    }

    private void read(List<Message> messages, int batchSize, long endTime) throws InterruptedException {
        Message msg = this.nextMessageWithEndTime(endTime);
        while (msg != null) {
            messages.add(msg);
            msg = null;
            if (messages.size() >= batchSize) continue;
            msg = this.nextMessageWithEndTime(endTime);
        }
    }

    private void durationGtZeroRequired(Duration duration, String label) {
        if (duration == null || duration.toMillis() <= 0L) {
            throw new IllegalArgumentException(label + " must be supplied and greater than 0.");
        }
    }

    private void _pull(int batchSize, boolean noWait, Duration expiresIn) {
        int batch = Validator.validatePullBatchSize(batchSize);
        String publishSubject = this.js.prependPrefix(String.format("CONSUMER.MSG.NEXT.%s.%s", this.stream, this.consumerName));
        this.connection.publish(publishSubject, this.getSubject(), this.getPullJson(batch, noWait, expiresIn));
        this.connection.lenientFlushBuffer();
    }

    byte[] getPullJson(int batch, boolean noWait, Duration expiresIn) {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "batch", batch);
        JsonUtils.addFldWhenTrue(sb, "no_wait", noWait);
        JsonUtils.addFieldAsNanos(sb, "expires", expiresIn);
        return JsonUtils.endJson(sb).toString().getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, Duration maxWait) {
        return this.iterate(batchSize, maxWait.toMillis());
    }

    @Override
    public Iterator<Message> iterate(final int batchSize, final long maxWaitMillis) {
        this.pullNoWait(batchSize);
        return new Iterator<Message>(){
            int received = 0;
            long timeLeft = Long.MAX_VALUE;
            Message msg = null;

            @Override
            public boolean hasNext() {
                try {
                    if (this.msg == null) {
                        if (this.timeLeft < 1L) {
                            return false;
                        }
                        if (this.timeLeft == Long.MAX_VALUE) {
                            this.timeLeft = maxWaitMillis;
                        }
                        long endTime = System.currentTimeMillis() + this.timeLeft;
                        this.msg = NatsJetStreamPullSubscription.this.nextMessageWithEndTime(endTime);
                        if (this.msg == null) {
                            this.timeLeft = 0L;
                            return false;
                        }
                        this.timeLeft = ++this.received == batchSize ? 0L : endTime - System.currentTimeMillis();
                    }
                    return true;
                }
                catch (InterruptedException e) {
                    this.msg = null;
                    this.timeLeft = 0L;
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            public Message next() {
                Message next = this.msg;
                this.msg = null;
                return next;
            }
        };
    }
}

