/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;

public class ConsumerLimits
implements JsonSerializable {
    private final Duration inactiveThreshold;
    private final Integer maxAckPending;

    static ConsumerLimits optionalInstance(JsonValue vConsumerLimits) {
        return vConsumerLimits == null ? null : new ConsumerLimits(vConsumerLimits);
    }

    ConsumerLimits(JsonValue vConsumerLimits) {
        this.inactiveThreshold = JsonValueUtils.readNanos(vConsumerLimits, "inactive_threshold");
        this.maxAckPending = JsonValueUtils.readInteger(vConsumerLimits, "max_ack_pending");
    }

    ConsumerLimits(Builder b) {
        this.inactiveThreshold = b.inactiveThreshold;
        this.maxAckPending = b.maxAckPending;
    }

    public Duration getInactiveThreshold() {
        return this.inactiveThreshold;
    }

    public long getMaxAckPending() {
        return ConsumerConfiguration.getOrUnset(this.maxAckPending);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addFieldAsNanos(sb, "inactive_threshold", this.inactiveThreshold);
        JsonUtils.addField(sb, "max_ack_pending", this.maxAckPending);
        return JsonUtils.endJson(sb).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration inactiveThreshold;
        private Integer maxAckPending;

        public Builder inactiveThreshold(Duration inactiveThreshold) {
            this.inactiveThreshold = ConsumerConfiguration.normalize(inactiveThreshold);
            return this;
        }

        public Builder inactiveThreshold(long inactiveThreshold) {
            this.inactiveThreshold = ConsumerConfiguration.normalizeDuration(inactiveThreshold);
            return this;
        }

        public Builder maxAckPending(Long maxAckPending) {
            this.maxAckPending = ConsumerConfiguration.normalize(maxAckPending, 0);
            return this;
        }

        public Builder maxAckPending(long maxAckPending) {
            this.maxAckPending = ConsumerConfiguration.normalize(maxAckPending, 0);
            return this;
        }

        public ConsumerLimits build() {
            return new ConsumerLimits(this);
        }
    }
}

