/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.SubscribeOptions;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.PullManagerObserver;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

abstract class MessageManager {
    protected static final int THRESHOLD = 3;
    protected final ReentrantLock stateChangeLock = new ReentrantLock();
    protected final NatsConnection conn;
    protected final SubscribeOptions so;
    protected final boolean syncMode;
    protected NatsJetStreamSubscription sub;
    protected long lastStreamSeq;
    protected long lastConsumerSeq;
    protected AtomicLong lastMsgReceived;
    protected boolean hb;
    protected long idleHeartbeatSetting;
    protected long alarmPeriodSetting;
    protected MmTimerTask heartbeatTimerTask;
    protected Timer heartbeatTimer;

    protected MessageManager(NatsConnection conn, SubscribeOptions so, boolean syncMode) {
        this.conn = conn;
        this.so = so;
        this.syncMode = syncMode;
        this.lastStreamSeq = 0L;
        this.lastConsumerSeq = 0L;
        this.hb = false;
        this.idleHeartbeatSetting = 0L;
        this.alarmPeriodSetting = 0L;
        this.lastMsgReceived = new AtomicLong(System.currentTimeMillis());
    }

    protected boolean isSyncMode() {
        return this.syncMode;
    }

    protected long getLastStreamSequence() {
        return this.lastStreamSeq;
    }

    protected long getLastConsumerSequence() {
        return this.lastConsumerSeq;
    }

    protected long getLastMsgReceived() {
        return this.lastMsgReceived.get();
    }

    protected boolean isHb() {
        return this.hb;
    }

    protected long getIdleHeartbeatSetting() {
        return this.idleHeartbeatSetting;
    }

    protected long getAlarmPeriodSetting() {
        return this.alarmPeriodSetting;
    }

    protected void startup(NatsJetStreamSubscription sub) {
        this.sub = sub;
    }

    protected void shutdown() {
        this.shutdownHeartbeatTimer();
    }

    protected void startPullRequest(String pullSubject, PullRequestOptions pullRequestOptions, boolean raiseStatusWarnings, PullManagerObserver pullManagerObserver) {
    }

    protected Boolean beforeQueueProcessorImpl(NatsMessage msg) {
        return true;
    }

    protected abstract ManageResult manage(Message var1);

    protected void trackJsMessage(Message msg) {
        this.stateChangeLock.lock();
        try {
            NatsJetStreamMetaData meta = msg.metaData();
            this.lastStreamSeq = meta.streamSequence();
            ++this.lastConsumerSeq;
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    protected void handleHeartbeatError() {
        this.conn.executeCallback((c, el) -> el.heartbeatAlarm(c, this.sub, this.lastStreamSeq, this.lastConsumerSeq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureIdleHeartbeat(Duration configIdleHeartbeat, long configMessageAlarmTime) {
        this.stateChangeLock.lock();
        try {
            long l = this.idleHeartbeatSetting = configIdleHeartbeat == null ? 0L : configIdleHeartbeat.toMillis();
            if (this.idleHeartbeatSetting <= 0L) {
                this.alarmPeriodSetting = 0L;
                this.hb = false;
            } else {
                this.alarmPeriodSetting = configMessageAlarmTime < this.idleHeartbeatSetting ? this.idleHeartbeatSetting * 3L : configMessageAlarmTime;
                this.hb = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    protected void updateLastMessageReceived() {
        this.lastMsgReceived.set(System.currentTimeMillis());
    }

    protected void initOrResetHeartbeatTimer() {
        this.stateChangeLock.lock();
        try {
            if (this.heartbeatTimer != null) {
                if (this.heartbeatTimerTask.alarmPeriod == this.alarmPeriodSetting) {
                    this.heartbeatTimerTask.reuse();
                    this.updateLastMessageReceived();
                    return;
                }
                this.shutdownHeartbeatTimer();
            }
            this.heartbeatTimer = new Timer();
            this.heartbeatTimerTask = new MmTimerTask(this.alarmPeriodSetting);
            this.heartbeatTimer.schedule((TimerTask)this.heartbeatTimerTask, this.alarmPeriodSetting, this.alarmPeriodSetting);
            this.updateLastMessageReceived();
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    protected void shutdownHeartbeatTimer() {
        this.stateChangeLock.lock();
        try {
            if (this.heartbeatTimer != null) {
                this.heartbeatTimerTask.shutdown();
                this.heartbeatTimerTask = null;
                this.heartbeatTimer.cancel();
                this.heartbeatTimer = null;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    class MmTimerTask
    extends TimerTask {
        long alarmPeriod;
        final AtomicBoolean alive;

        public MmTimerTask(long alarmPeriod) {
            this.alarmPeriod = alarmPeriod;
            this.alive = new AtomicBoolean(true);
        }

        public void reuse() {
            this.alive.getAndSet(true);
        }

        public void shutdown() {
            this.alive.getAndSet(false);
        }

        @Override
        public void run() {
            if (this.alive.get() && !Thread.interrupted()) {
                long sinceLast = System.currentTimeMillis() - MessageManager.this.lastMsgReceived.get();
                if (this.alive.get() && sinceLast > MessageManager.this.alarmPeriodSetting) {
                    MessageManager.this.handleHeartbeatError();
                }
            }
        }

        public String toString() {
            long sinceLast = System.currentTimeMillis() - MessageManager.this.lastMsgReceived.get();
            return "MmTimerTask{, alarmPeriod=" + this.alarmPeriod + ", alive=" + this.alive.get() + ", sinceLast=" + sinceLast + '}';
        }
    }

    public static enum ManageResult {
        MESSAGE,
        STATUS_HANDLED,
        STATUS_TERMINUS,
        STATUS_ERROR;

    }
}

