/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.MessageConsumer;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.PullMessageManager;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

class NatsMessageConsumerBase
implements MessageConsumer {
    protected NatsJetStreamPullSubscription sub;
    protected PullMessageManager pmm;
    protected final AtomicBoolean stopped;
    protected final AtomicBoolean finished;
    protected ConsumerInfo cachedConsumerInfo;

    NatsMessageConsumerBase(ConsumerInfo cachedConsumerInfo) {
        this.cachedConsumerInfo = cachedConsumerInfo;
        this.stopped = new AtomicBoolean(false);
        this.finished = new AtomicBoolean(false);
    }

    void initSub(NatsJetStreamPullSubscription sub) {
        this.sub = sub;
        this.pmm = (PullMessageManager)sub.manager;
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @Override
    public String getConsumerName() {
        return this.sub.getConsumerName();
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        if (this.cachedConsumerInfo != null) {
            this.cachedConsumerInfo = this.sub.getConsumerInfo();
        }
        return this.cachedConsumerInfo;
    }

    @Override
    public ConsumerInfo getCachedConsumerInfo() {
        return this.cachedConsumerInfo;
    }

    @Override
    public void stop() {
        this.stopped.set(true);
    }

    @Override
    public void close() throws Exception {
        this.lenientClose();
    }

    protected void lenientClose() {
        try {
            if (!this.stopped.get() || this.sub.isActive()) {
                this.stopped.set(true);
                if (this.sub.getNatsDispatcher() != null) {
                    this.sub.getDispatcher().unsubscribe(this.sub);
                } else {
                    this.sub.unsubscribe();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

