/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.Message;
import io.nats.client.Options;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public class NatsRequestCompletableFuture
extends CompletableFuture<Message> {
    private static final String CLOSING_MESSAGE = "Future cancelled, connection closing.";
    private static final String CANCEL_MESSAGE = "Future cancelled, response not registered in time, check connection status.";
    private static final long DEFAULT_TIMEOUT = Options.DEFAULT_REQUEST_CLEANUP_INTERVAL.toMillis();
    private final CancelAction cancelAction;
    private final long timeOutAfter;
    private boolean wasCancelledClosing;
    private boolean wasCancelledTimedOut;
    private final boolean useTimeoutException;

    public NatsRequestCompletableFuture(CancelAction cancelAction, Duration timeout, boolean useTimeoutException) {
        this.cancelAction = cancelAction;
        this.timeOutAfter = System.currentTimeMillis() + 10L + (timeout == null ? DEFAULT_TIMEOUT : timeout.toMillis());
        this.useTimeoutException = useTimeoutException;
    }

    public void cancelClosing() {
        this.wasCancelledClosing = true;
        this.completeExceptionally(new CancellationException(CLOSING_MESSAGE));
    }

    public void cancelTimedOut() {
        this.wasCancelledTimedOut = true;
        this.completeExceptionally(this.useTimeoutException ? new TimeoutException(CANCEL_MESSAGE) : new CancellationException(CANCEL_MESSAGE));
    }

    public CancelAction getCancelAction() {
        return this.cancelAction;
    }

    public boolean useTimeoutException() {
        return this.useTimeoutException;
    }

    public boolean hasExceededTimeout() {
        return System.currentTimeMillis() > this.timeOutAfter;
    }

    public boolean wasCancelledClosing() {
        return this.wasCancelledClosing;
    }

    public boolean wasCancelledTimedOut() {
        return this.wasCancelledTimedOut;
    }

    public static enum CancelAction {
        CANCEL,
        REPORT,
        COMPLETE;

    }
}

