/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.WebsocketFrameHeader;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Random;

public class WebsocketOutputStream
extends OutputStream {
    private OutputStream wrap;
    private boolean masked;
    private byte[] oneByte = new byte[1];
    private byte[] headerBuffer = new byte[1440];
    private WebsocketFrameHeader header = new WebsocketFrameHeader().withOp(WebsocketFrameHeader.OpCode.BINARY, true).withNoMask();
    private Random random = new SecureRandom();

    public WebsocketOutputStream(OutputStream wrap, boolean masked) {
        this.wrap = wrap;
        this.masked = masked;
    }

    @Override
    public void close() throws IOException {
        WebsocketFrameHeader header = new WebsocketFrameHeader().withOp(WebsocketFrameHeader.OpCode.CLOSE, true).withNoMask().withPayloadLength(0L);
        int length = header.read(this.headerBuffer, 0, this.headerBuffer.length);
        this.wrap.write(this.headerBuffer, 0, length);
        this.wrap.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrap.flush();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)(b & 0xFF);
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.header.withPayloadLength(length);
        if (this.masked) {
            this.header.withMask(this.random.nextInt());
        }
        int headerBufferOffset = this.header.read(this.headerBuffer, 0, this.headerBuffer.length);
        int consumed = Math.min(length, this.headerBuffer.length - headerBufferOffset);
        System.arraycopy(buffer, offset, this.headerBuffer, headerBufferOffset, consumed);
        this.header.filterPayload(this.headerBuffer, headerBufferOffset, consumed);
        this.wrap.write(this.headerBuffer, 0, headerBufferOffset + consumed);
        if (consumed < length) {
            this.header.filterPayload(buffer, offset + consumed, length - consumed);
            this.wrap.write(buffer, offset + consumed, length - consumed);
        }
    }
}

