/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.Validator;

public class MessageTtl {
    private final String ttlString;

    private MessageTtl(String ttlString) {
        this.ttlString = ttlString;
    }

    public String getTtlString() {
        return this.ttlString;
    }

    public String toString() {
        return "MessageTtl{'" + this.ttlString + "'}";
    }

    public static MessageTtl seconds(int msgTtlSeconds) {
        if (msgTtlSeconds < 1) {
            throw new IllegalArgumentException("Must be at least 1 second.");
        }
        return new MessageTtl(msgTtlSeconds + "s");
    }

    public static MessageTtl custom(String messageTtlCustom) {
        if (Validator.nullOrEmpty(messageTtlCustom)) {
            throw new IllegalArgumentException("Custom value required.");
        }
        return new MessageTtl(messageTtlCustom);
    }

    public static MessageTtl never() {
        return new MessageTtl("never");
    }
}

