/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.time.Duration;
import org.jspecify.annotations.NonNull;

public class PullRequestOptions
implements JsonSerializable {
    private final int batchSize;
    private final long maxBytes;
    private final boolean noWait;
    private final Duration expiresIn;
    private final Duration idleHeartbeat;
    private final String group;
    private final int priority;
    private final long minPending;
    private final long minAckPending;

    public PullRequestOptions(Builder b) {
        this.batchSize = b.batchSize;
        this.maxBytes = b.maxBytes;
        this.noWait = b.noWait;
        this.expiresIn = b.expiresIn;
        this.idleHeartbeat = b.idleHeartbeat;
        this.group = b.group;
        this.priority = b.priority;
        this.minPending = b.minPending < 0L ? -1L : b.minPending;
        this.minAckPending = b.minAckPending < 0L ? -1L : b.minAckPending;
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "batch", this.batchSize);
        JsonUtils.addField(sb, "max_bytes", this.maxBytes);
        JsonUtils.addFldWhenTrue(sb, "no_wait", this.noWait);
        JsonUtils.addFieldAsNanos(sb, "expires", this.expiresIn);
        JsonUtils.addFieldAsNanos(sb, "idle_heartbeat", this.idleHeartbeat);
        JsonUtils.addField(sb, "group", this.group);
        JsonUtils.addFieldWhenGtZero(sb, "priority", this.priority);
        JsonUtils.addField(sb, "id", this.getPinId());
        JsonUtils.addField(sb, "min_pending", this.minPending);
        JsonUtils.addField(sb, "min_ack_pending", this.minAckPending);
        return JsonUtils.endJson(sb).toString();
    }

    protected String getPinId() {
        return null;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public Duration getExpiresIn() {
        return this.expiresIn;
    }

    public Duration getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public String getGroup() {
        return this.group;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getMinPending() {
        return this.minPending;
    }

    public long getMinAckPending() {
        return this.minAckPending;
    }

    public static Builder builder(int batchSize) {
        return new Builder().batchSize(batchSize);
    }

    public static Builder noWait(int batchSize) {
        return new Builder().batchSize(batchSize).noWait();
    }

    public static class Builder {
        private int batchSize;
        private long maxBytes;
        private boolean noWait;
        private Duration expiresIn;
        private Duration idleHeartbeat;
        private String group;
        private int priority;
        private long minPending = -1L;
        private long minAckPending = -1L;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder maxBytes(long maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public Builder noWait() {
            this.noWait = true;
            return this;
        }

        public Builder noWait(boolean noWait) {
            this.noWait = noWait;
            return this;
        }

        public Builder expiresIn(long expiresInMillis) {
            this.expiresIn = Duration.ofMillis(expiresInMillis);
            return this;
        }

        public Builder expiresIn(Duration expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder idleHeartbeat(long idleHeartbeatMillis) {
            this.idleHeartbeat = Duration.ofMillis(idleHeartbeatMillis);
            return this;
        }

        public Builder idleHeartbeat(Duration idleHeartbeat) {
            this.idleHeartbeat = idleHeartbeat;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder minPending(long minPending) {
            this.minPending = minPending < 1L ? -1L : minPending;
            return this;
        }

        public Builder minAckPending(long minAckPending) {
            this.minAckPending = minAckPending < 1L ? -1L : minAckPending;
            return this;
        }

        public PullRequestOptions build() {
            long idleNanosTemp;
            Validator.validateGtZero(this.batchSize, "Pull batch size");
            if (this.priority < 0 || this.priority > 9) {
                throw new IllegalArgumentException("Priority must be between 0 and 9 inclusive.");
            }
            if (this.idleHeartbeat != null && (idleNanosTemp = this.idleHeartbeat.toNanos() * 2L) > 0L) {
                if (this.expiresIn == null) {
                    throw new IllegalArgumentException("Idle Heartbeat not allowed without expiration.");
                }
                long expiresNanos = this.expiresIn.toNanos();
                if (idleNanosTemp > expiresNanos) {
                    throw new IllegalArgumentException("Idle Heartbeat cannot be more than half the expiration.");
                }
            }
            return new PullRequestOptions(this);
        }
    }
}

