/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.ZonedDateTime;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class PriorityGroupState {
    private final String group;
    private final String pinnedClientId;
    private final ZonedDateTime pinnedTime;

    static List<PriorityGroupState> optionalListOf(JsonValue vpgStates) {
        return JsonValueUtils.optionalListOf(vpgStates, PriorityGroupState::new);
    }

    PriorityGroupState(JsonValue vpgState) {
        this.group = JsonValueUtils.readString(vpgState, "group");
        this.pinnedClientId = JsonValueUtils.readString(vpgState, "pinned_client_id");
        this.pinnedTime = JsonValueUtils.readDate(vpgState, "pinned_ts");
    }

    public @NonNull String getGroup() {
        return this.group;
    }

    public @Nullable String getPinnedClientId() {
        return this.pinnedClientId;
    }

    public @Nullable ZonedDateTime getPinnedTime() {
        return this.pinnedTime;
    }

    public String toString() {
        return "PriorityGroupState{group='" + this.group + '\'' + ", pinnedClientId='" + this.pinnedClientId + '\'' + ", pinnedTime=" + this.pinnedTime + '}';
    }
}

