/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.KeyValueEntry;
import io.nats.client.api.KeyValueOperation;
import io.nats.client.api.KeyValueWatchOption;
import io.nats.client.api.KeyValueWatcher;
import io.nats.client.api.Watcher;
import io.nats.client.impl.NatsKeyValue;
import io.nats.client.impl.NatsWatchSubscription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class NatsKeyValueWatchSubscription
extends NatsWatchSubscription<KeyValueEntry> {
    public NatsKeyValueWatchSubscription(NatsKeyValue kv, String keyPattern, KeyValueWatcher watcher, long fromRevision, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException {
        this(kv, Collections.singletonList(keyPattern), watcher, fromRevision, watchOptions);
    }

    public NatsKeyValueWatchSubscription(NatsKeyValue kv, List<String> keyPatterns, KeyValueWatcher watcher, long fromRevision, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException {
        super(kv.js);
        this.kvWatchInit(kv, keyPatterns, watcher, fromRevision, watchOptions);
    }

    private void kvWatchInit(NatsKeyValue kv, List<String> keyPatterns, KeyValueWatcher watcher, long fromRevision, KeyValueWatchOption[] watchOptions) throws IOException, JetStreamApiException {
        boolean headersOnly = false;
        boolean ignoreDeletes = false;
        DeliverPolicy deliverPolicy = DeliverPolicy.LastPerSubject;
        if (watchOptions != null) {
            block6: for (KeyValueWatchOption wo : watchOptions) {
                if (wo == null) continue;
                switch (wo) {
                    case META_ONLY: {
                        headersOnly = true;
                        continue block6;
                    }
                    case IGNORE_DELETE: {
                        ignoreDeletes = true;
                        continue block6;
                    }
                    case UPDATES_ONLY: {
                        deliverPolicy = DeliverPolicy.New;
                        continue block6;
                    }
                    case INCLUDE_HISTORY: {
                        deliverPolicy = DeliverPolicy.All;
                    }
                }
            }
        }
        ArrayList<String> readSubjects = new ArrayList<String>();
        for (String keyPattern : keyPatterns) {
            readSubjects.add(kv.readSubject(keyPattern.trim()));
        }
        this.finishInit(kv, readSubjects, deliverPolicy, headersOnly, fromRevision, NatsKeyValueWatchSubscription.getHandler(watcher, !ignoreDeletes), watcher.getConsumerNamePrefix());
    }

    private static @NonNull NatsWatchSubscription.WatchMessageHandler<KeyValueEntry> getHandler(final KeyValueWatcher watcher, final boolean includeDeletes) {
        return new NatsWatchSubscription.WatchMessageHandler<KeyValueEntry>((Watcher)watcher){

            @Override
            public void onMessage(Message m) throws InterruptedException {
                KeyValueEntry kve = new KeyValueEntry(m);
                if (includeDeletes || kve.getOperation() == KeyValueOperation.PUT) {
                    watcher.watch(kve);
                }
                if (!this.endOfDataSent && kve.getDelta() == 0L) {
                    this.sendEndOfData();
                }
            }
        };
    }
}

