/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumerContext;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.OrderedConsumerContext;
import io.nats.client.PurgeOptions;
import io.nats.client.StreamContext;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.OrderedConsumerConfiguration;
import io.nats.client.api.PurgeResponse;
import io.nats.client.api.StreamInfo;
import io.nats.client.api.StreamInfoOptions;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamManagement;
import io.nats.client.impl.NatsOrderedConsumerContext;
import java.io.IOException;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class NatsStreamContext
implements StreamContext {
    final String streamName;
    final NatsJetStream js;
    final NatsJetStreamManagement jsm;

    NatsStreamContext(@NonNull String streamName, @Nullable NatsJetStream js, @NonNull NatsConnection connection, @Nullable JetStreamOptions jsOptions) throws IOException, JetStreamApiException {
        this.streamName = streamName;
        this.js = js == null ? new NatsJetStream(connection, jsOptions) : js;
        this.jsm = new NatsJetStreamManagement(connection, jsOptions);
        this.jsm.getStreamInfo(streamName);
    }

    @Override
    public @NonNull String getStreamName() {
        return this.streamName;
    }

    @Override
    public @NonNull StreamInfo getStreamInfo() throws IOException, JetStreamApiException {
        return this.jsm.getStreamInfo(this.streamName, null);
    }

    @Override
    public @NonNull StreamInfo getStreamInfo(@Nullable StreamInfoOptions options) throws IOException, JetStreamApiException {
        return this.jsm.getStreamInfo(this.streamName, options);
    }

    @Override
    public @NonNull PurgeResponse purge() throws IOException, JetStreamApiException {
        return this.jsm.purgeStream(this.streamName);
    }

    @Override
    public @NonNull PurgeResponse purge(@NonNull PurgeOptions options) throws IOException, JetStreamApiException {
        return this.jsm.purgeStream(this.streamName, options);
    }

    @Override
    public @NonNull ConsumerContext getConsumerContext(@NonNull String consumerName) throws IOException, JetStreamApiException {
        return new NatsConsumerContext(this, this.jsm.getConsumerInfo(this.streamName, consumerName), null);
    }

    @Override
    public @NonNull ConsumerContext createOrUpdateConsumer(@NonNull ConsumerConfiguration config) throws IOException, JetStreamApiException {
        return new NatsConsumerContext(this, this.jsm.addOrUpdateConsumer(this.streamName, config), null);
    }

    @Override
    public @NonNull OrderedConsumerContext createOrderedConsumer(@NonNull OrderedConsumerConfiguration config) throws IOException, JetStreamApiException {
        return new NatsOrderedConsumerContext(this, config);
    }

    @Override
    public boolean deleteConsumer(@NonNull String consumerName) throws IOException, JetStreamApiException {
        return this.jsm.deleteConsumer(this.streamName, consumerName);
    }

    @Override
    public @NonNull ConsumerInfo getConsumerInfo(@NonNull String consumerName) throws IOException, JetStreamApiException {
        return this.jsm.getConsumerInfo(this.streamName, consumerName);
    }

    @Override
    public @NonNull List<String> getConsumerNames() throws IOException, JetStreamApiException {
        return this.jsm.getConsumerNames(this.streamName);
    }

    @Override
    public @NonNull List<ConsumerInfo> getConsumers() throws IOException, JetStreamApiException {
        return this.jsm.getConsumers(this.streamName);
    }

    @Override
    public @NonNull MessageInfo getMessage(long seq) throws IOException, JetStreamApiException {
        return this.jsm.getMessage(this.streamName, seq);
    }

    @Override
    public @NonNull MessageInfo getLastMessage(@NonNull String subject) throws IOException, JetStreamApiException {
        return this.jsm.getLastMessage(this.streamName, subject);
    }

    @Override
    public @NonNull MessageInfo getFirstMessage(@NonNull String subject) throws IOException, JetStreamApiException {
        return this.jsm.getFirstMessage(this.streamName, subject);
    }

    @Override
    public @NonNull MessageInfo getNextMessage(long seq, @NonNull String subject) throws IOException, JetStreamApiException {
        return this.jsm.getNextMessage(this.streamName, seq, subject);
    }

    @Override
    public boolean deleteMessage(long seq) throws IOException, JetStreamApiException {
        return this.jsm.deleteMessage(this.streamName, seq);
    }

    @Override
    public boolean deleteMessage(long seq, boolean erase) throws IOException, JetStreamApiException {
        return this.jsm.deleteMessage(this.streamName, seq, erase);
    }
}

