/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.examples.ExampleAuthHandler;
import io.nats.examples.ExampleUtils;
import java.time.Duration;

public class ConnectTime {
    public static Options createOptions(String server) throws Exception {
        Options.Builder builder = new Options.Builder().server(server).connectionTimeout(Duration.ofSeconds(5L)).pingInterval(Duration.ofSeconds(10L)).reconnectWait(Duration.ofSeconds(1L)).maxReconnects(-1).traceConnection();
        builder = builder.connectionListener((conn, type) -> System.out.println("Status change " + (Object)((Object)type)));
        builder = builder.errorListener(new ErrorListener(){

            @Override
            public void slowConsumerDetected(Connection conn, Consumer consumer) {
                System.out.println("NATS connection slow consumer detected");
            }

            @Override
            public void exceptionOccurred(Connection conn, Exception exp) {
                System.out.println("NATS connection exception occurred");
                exp.printStackTrace();
            }

            @Override
            public void errorOccurred(Connection conn, String error) {
                System.out.println("NATS connection error occurred " + error);
            }
        });
        if (System.getenv("NATS_NKEY") != null && System.getenv("NATS_NKEY") != "") {
            ExampleAuthHandler handler = new ExampleAuthHandler(System.getenv("NATS_NKEY"));
            builder.authHandler(handler);
        } else if (System.getenv("NATS_CREDS") != null && System.getenv("NATS_CREDS") != "") {
            builder.authHandler(Nats.credentials(System.getenv("NATS_CREDS")));
        }
        return builder.build();
    }

    public static void main(String[] args) {
        String server = ExampleUtils.getServer(args);
        try {
            System.out.println();
            System.out.printf("Timing connect time to %s.\n", server);
            System.out.println();
            Options options = ConnectTime.createOptions(server);
            long start = System.nanoTime();
            Connection nc = Nats.connect(options);
            long end = System.nanoTime();
            double seconds = (double)(end - start) / 1.0E9;
            System.out.printf("Connect time to %s was %.3f seconds\n", server, seconds);
            nc.close();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

