/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.Subscription;
import io.nats.examples.autobench.AutoBenchmark;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class LatencyBenchmark
extends AutoBenchmark {
    static FileOutputStream lcsvOut;
    static List<Long> allPayloadSizes;
    static List<List<Long>> allMeasurements;
    final ArrayList<Long> measurements = new ArrayList((int)this.getMessageCount());
    final String lcsv;

    public LatencyBenchmark(String name, long messageCount, long messageSize, String lcsv) {
        super(name, messageCount, messageSize);
        this.lcsv = lcsv;
    }

    @Override
    public void execute(Options connectOptions) throws InterruptedException {
        byte[] payload = this.createPayload();
        String subject = this.getSubject();
        CompletableFuture<Object> go = new CompletableFuture<Object>();
        CompletableFuture<Void> subReady = new CompletableFuture<Void>();
        CompletableFuture<Void> pubReady = new CompletableFuture<Void>();
        CompletableFuture<Void> subDone = new CompletableFuture<Void>();
        CompletableFuture<Void> pubDone = new CompletableFuture<Void>();
        CyclicBarrier lockStep = new CyclicBarrier(2);
        AtomicLong start = new AtomicLong();
        Thread subThread = new Thread(() -> {
            try {
                Connection subConnect = Nats.connect(connectOptions);
                if (subConnect.getStatus() != Connection.Status.CONNECTED) {
                    throw new Exception("Unable to connect");
                }
                try {
                    Subscription sub = subConnect.subscribe(subject);
                    subConnect.flush(Duration.ofSeconds(5L));
                    subReady.complete(null);
                    go.get();
                    int count = 0;
                    while ((long)count < this.getMessageCount()) {
                        Message msg = sub.nextMessage(Duration.ofSeconds(5L));
                        if (msg == null) continue;
                        this.measurements.add(System.nanoTime() - start.get());
                        ++count;
                        lockStep.await(5000L, TimeUnit.MILLISECONDS);
                    }
                    subDone.complete(null);
                }
                catch (Exception exp) {
                    this.setException(exp);
                }
                finally {
                    subConnect.close();
                }
            }
            catch (Exception ex) {
                subReady.cancel(true);
                this.setException(ex);
            }
            finally {
                subDone.complete(null);
            }
        }, "Latency Test - Subscriber");
        subThread.start();
        Thread pubThread = new Thread(() -> {
            try {
                Connection pubConnect = Nats.connect(connectOptions);
                if (pubConnect.getStatus() != Connection.Status.CONNECTED) {
                    throw new Exception("Unable to connect");
                }
                try {
                    pubReady.complete(null);
                    go.get();
                    int i = 0;
                    while ((long)i < this.getMessageCount()) {
                        lockStep.reset();
                        start.set(System.nanoTime());
                        pubConnect.publish(subject, payload);
                        try {
                            pubConnect.flush(Duration.ofMillis(5000L));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        lockStep.await();
                        ++i;
                    }
                    pubDone.complete(null);
                }
                finally {
                    pubConnect.close();
                }
            }
            catch (Exception ex) {
                pubReady.cancel(true);
                this.setException(ex);
            }
            finally {
                pubDone.complete(null);
            }
        }, "Latency Test - Publisher");
        pubThread.start();
        this.getFutureSafely(subReady);
        this.getFutureSafely(pubReady);
        if (this.getException() != null) {
            go.complete(null);
            return;
        }
        go.complete(null);
        this.getFutureSafely(pubDone);
        this.getFutureSafely(subDone);
    }

    @Override
    public void beforePrintFirstOfKind() {
        System.out.println("Latency                 |           nanos              |            |");
        System.out.println("| payload     |   count |    min |  median  |      max | std dev ms |");
        System.out.println("| ----------- | ------- | ------ | -------- | -------- | ---------- |");
        if (this.lcsv != null) {
            try {
                lcsvOut = new FileOutputStream(this.lcsv);
                allPayloadSizes = new ArrayList<Long>();
                allMeasurements = new ArrayList<List<Long>>();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void printResult() {
        if (this.getException() != null) {
            String message = this.getException().getMessage();
            if (message == null) {
                message = this.getException().getClass().getCanonicalName();
            }
            System.out.printf("%-18s Exception: %12s\n", this.getName(), message);
            return;
        }
        if (allMeasurements != null) {
            allPayloadSizes.add(this.getMessageSize());
            allMeasurements.add(this.measurements);
        }
        LongSummaryStatistics stats = this.measurements.stream().mapToLong(Long::longValue).collect(LongSummaryStatistics::new, LongSummaryStatistics::accept, LongSummaryStatistics::combine);
        long min = stats.getMin() / 1000L;
        long max = stats.getMax() / 1000L;
        long count = stats.getCount();
        double average = stats.getAverage() / 1000.0;
        double median = this.calcMedian() / 1000.0;
        double stdDev = Math.sqrt(this.measurements.stream().mapToDouble(Long::doubleValue).map(d -> (d - average) * (d - average)).sum()) / (1000.0 * (double)(count - 1L));
        System.out.printf("| %-11s | %7s | %6s | %8.2f | %8s | +/- %6.2f |\n", this.getName().replace("Latency ", "") + " bytes", NumberFormat.getIntegerInstance().format(count), NumberFormat.getIntegerInstance().format(min), median, NumberFormat.getIntegerInstance().format(max), stdDev);
    }

    @Override
    public void afterPrintLastOfKind() {
        if (allMeasurements != null) {
            try {
                int cols = allPayloadSizes.size();
                int rows = allMeasurements.get(0).size();
                StringBuilder sb = new StringBuilder();
                for (int c = 0; c < cols; ++c) {
                    if (c > 0) {
                        sb.append(",");
                    }
                    sb.append(allPayloadSizes.get(c)).append(" bytes");
                }
                sb.append("\r\n");
                lcsvOut.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
                for (int r = 0; r < rows; ++r) {
                    sb.setLength(0);
                    for (int c = 0; c < cols; ++c) {
                        if (c > 0) {
                            sb.append(",");
                        }
                        sb.append(allMeasurements.get(c).get(r));
                    }
                    sb.append("\r\n");
                    lcsvOut.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public double calcMedian() {
        int size = this.measurements.size();
        int middle = this.measurements.size() / 2;
        this.measurements.sort(Long::compareTo);
        if (size % 2 == 1) {
            return this.measurements.get(middle).longValue();
        }
        double low = this.measurements.get(middle - 1).doubleValue() / 2.0;
        double high = this.measurements.get(middle).doubleValue() / 2.0;
        return high + low;
    }
}

