/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.benchmark;

import io.nats.client.NUID;
import io.nats.examples.benchmark.Sample;
import io.nats.examples.benchmark.SampleGroup;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Benchmark
extends Sample {
    private String name = null;
    private String runId = null;
    private final SampleGroup pubs = new SampleGroup(new SampleGroup[0]);
    private final SampleGroup subs = new SampleGroup(new SampleGroup[0]);
    private BlockingQueue<Sample> pubChannel;
    private BlockingQueue<Sample> subChannel;

    public Benchmark(String name) {
        this(name, NUID.nextGlobal());
    }

    public Benchmark(String name, String runId) {
        this.name = name;
        this.runId = runId;
        this.subChannel = new LinkedBlockingQueue<Sample>();
        this.pubChannel = new LinkedBlockingQueue<Sample>();
    }

    public final void addPubSample(Sample sample) {
        this.pubChannel.add(sample);
    }

    public final void addSubSample(Sample sample) {
        this.subChannel.add(sample);
    }

    public final void close() {
        while (this.subChannel.size() > 0) {
            this.subs.addSample((Sample)this.subChannel.poll());
        }
        while (this.pubChannel.size() > 0) {
            this.pubs.addSample((Sample)this.pubChannel.poll());
        }
        if (this.subs.hasSamples()) {
            this.start = this.subs.getStart();
            this.end = this.subs.getEnd();
            if (this.pubs.hasSamples()) {
                this.end = Math.min(this.end, this.pubs.getEnd());
            }
        } else {
            this.start = this.pubs.getStart();
            this.end = this.pubs.getEnd();
        }
        this.msgBytes = this.pubs.msgBytes + this.subs.msgBytes;
        this.ioBytes = this.pubs.ioBytes + this.subs.ioBytes;
        this.msgCnt = this.pubs.msgCnt + this.subs.msgCnt;
        this.jobMsgCnt = this.pubs.jobMsgCnt + this.subs.jobMsgCnt;
    }

    public final String report() {
        String indent;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s stats: %s\n", this.name, this));
        if (this.pubs.hasSamples()) {
            indent = " ";
            if (this.subs.hasSamples()) {
                sb.append(String.format("%sPub stats: %s\n", indent, this.pubs));
                indent = "  ";
            }
            if (this.pubs.getSamples().size() > 1) {
                for (Sample stat : this.pubs.getSamples()) {
                    sb.append(String.format("%s[%2d] %s (%d msgs)\n", indent, this.pubs.getSamples().indexOf(stat) + 1, stat, stat.jobMsgCnt));
                }
                sb.append(String.format("%s %s\n", indent, this.pubs.statistics()));
            }
        }
        if (this.subs.hasSamples()) {
            indent = " ";
            sb.append(String.format("%sSub stats: %s\n", indent, this.subs));
            indent = "  ";
            if (this.subs.getSamples().size() > 1) {
                for (Sample stat : this.subs.getSamples()) {
                    sb.append(String.format("%s[%2d] %s (%d msgs)\n", indent, this.subs.getSamples().indexOf(stat) + 1, stat, stat.jobMsgCnt));
                }
                sb.append(String.format("%s %s\n", indent, this.subs.statistics()));
            }
        }
        return sb.toString();
    }

    public final String csv() {
        StringBuilder sb = new StringBuilder();
        String header = "#RunID, ClientID, Test Msgs, MsgsPerSec, BytesPerSec, Total Msgs, Total Bytes, DurationSecs";
        sb.append(String.format("%s stats: %s\n", this.name, this));
        sb.append(header);
        sb.append("\n");
        sb.append(this.csvLines(this.subs, "S"));
        sb.append(this.csvLines(this.pubs, "P"));
        return sb.toString();
    }

    String csvLines(SampleGroup grp, String prefix) {
        StringBuilder sb = new StringBuilder();
        int j = 0;
        for (Sample stat : grp.getSamples()) {
            String line = String.format("%s,%s%d,%d,%d,%.2f,%d,%d,%.4f", this.runId, prefix, j++, stat.getJobMsgCnt(), stat.rate(), stat.throughput(), stat.msgCnt, stat.msgBytes, (double)stat.duration() / 1.0E9);
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getRunId() {
        return this.runId;
    }

    public final void setRunId(String runId) {
        this.runId = runId;
    }

    public final SampleGroup getPubs() {
        return this.pubs;
    }

    public final SampleGroup getSubs() {
        return this.subs;
    }
}

